/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.action;

import java.util.Arrays;
import org.freeplane.core.resources.SetBooleanPropertyAction;
import org.freeplane.core.resources.SetStringPropertyAction;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.menubuilders.generic.EntryVisitor;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.mode.FreeplaneActions;
import org.freeplane.features.styles.SetBooleanMapPropertyAction;
import org.freeplane.features.styles.SetBooleanMapViewPropertyAction;
import org.freeplane.features.styles.SetStringMapPropertyAction;

public class ActionFinder
implements EntryVisitor {
    private final FreeplaneActions freeplaneActions;

    public ActionFinder(FreeplaneActions freeplaneActions) {
        this.freeplaneActions = freeplaneActions;
    }

    @Override
    public void visit(Entry target) {
        String actionName = target.getName();
        if (!actionName.isEmpty() && new EntryAccessor().getAction(target) == null) {
            AFreeplaneAction action = this.freeplaneActions.getAction(actionName);
            if (action == null) {
                for (Class actionClass : Arrays.asList(SetBooleanPropertyAction.class, SetBooleanMapPropertyAction.class, SetBooleanMapViewPropertyAction.class, SetStringPropertyAction.class, SetStringMapPropertyAction.class)) {
                    String actionPrefix = actionClass.getSimpleName() + ".";
                    if (!actionName.startsWith(actionPrefix)) continue;
                    String propertyName = actionName.substring(actionPrefix.length());
                    action = this.createAction(actionClass, propertyName);
                    if (action == null) break;
                    this.freeplaneActions.addAction(action);
                    break;
                }
            }
            new EntryAccessor().setAction(target, action);
        }
    }

    AFreeplaneAction createAction(Class<? extends AFreeplaneAction> actionClass, String propertyName) {
        try {
            return actionClass.getConstructor(String.class).newInstance(propertyName);
        }
        catch (Exception e) {
            LogUtils.severe(e);
            return null;
        }
    }

    @Override
    public boolean shouldSkipChildren(Entry entry) {
        return false;
    }
}

