/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Objects;

public class Hyperlink {
    private URI uri;
    private String uriString;

    public Hyperlink(URI uri) {
        this.uri = uri;
    }

    public Hyperlink(String uriString, URI uri) {
        this.uriString = uriString;
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hyperlink other = (Hyperlink)obj;
        return Objects.equals(this.toString(), other.toString());
    }

    public String toString() {
        if (this.uriString == null) {
            this.uriString = this.uri.toString();
        }
        return this.uriString;
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public URL toUrl() throws MalformedURLException {
        String scheme = this.uri.getScheme();
        String host = this.uri.getHost() == null ? "" : this.uri.getHost();
        String path = this.uri.isOpaque() ? this.uri.getSchemeSpecificPart() : this.uri.getPath();
        int port = this.uri.getPort();
        String query = this.uri.getQuery();
        String fragment = this.uri.getFragment();
        StringBuilder file = new StringBuilder(path);
        if (query != null) {
            file.append('?');
            file.append(query);
        }
        if (fragment != null) {
            file.append('#');
            file.append(fragment);
        }
        URL url = new URL(scheme, host, port, file.toString());
        return url;
    }
}

