/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.Bridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.GraphicsNodeBridge;
import io.sf.carte.echosvg.bridge.SVGFontElementBridge;
import io.sf.carte.echosvg.gvt.font.GVTFont;
import io.sf.carte.echosvg.gvt.font.GVTFontFace;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import io.sf.carte.echosvg.gvt.text.GVTAttributedCharacterIterator;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGFontFamily
implements GVTFontFamily {
    public static final AttributedCharacterIterator.Attribute TEXT_COMPOUND_ID = GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_ID;
    protected GVTFontFace fontFace;
    protected Element fontElement;
    protected BridgeContext ctx;
    protected Boolean complex = null;

    public SVGFontFamily(GVTFontFace gVTFontFace, Element element, BridgeContext bridgeContext) {
        this.fontFace = gVTFontFace;
        this.fontElement = element;
        this.ctx = bridgeContext;
    }

    public String getFamilyName() {
        return this.fontFace.getFamilyName();
    }

    public GVTFontFace getFontFace() {
        return this.fontFace;
    }

    public GVTFont deriveFont(float f, AttributedCharacterIterator attributedCharacterIterator) {
        return this.deriveFont(f, attributedCharacterIterator.getAttributes());
    }

    public GVTFont deriveFont(float f, Map<AttributedCharacterIterator.Attribute, ?> map) {
        SVGFontElementBridge sVGFontElementBridge = (SVGFontElementBridge)this.ctx.getBridge(this.fontElement);
        if (sVGFontElementBridge == null) {
            return null;
        }
        SoftReference softReference = (SoftReference)map.get(TEXT_COMPOUND_ID);
        Element element = (Element)softReference.get();
        if (element == null) {
            return null;
        }
        return sVGFontElementBridge.createFont(this.ctx, this.fontElement, element, f, this.fontFace);
    }

    public boolean isComplex() {
        if (this.complex != null) {
            return this.complex;
        }
        boolean bl = SVGFontFamily.isComplex(this.fontElement, this.ctx);
        this.complex = bl ? Boolean.TRUE : Boolean.FALSE;
        return bl;
    }

    public static boolean isComplex(Element element, BridgeContext bridgeContext) {
        NodeList nodeList = element.getElementsByTagNameNS("http://www.w3.org/2000/svg", "glyph");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element2 = (Element)nodeList.item(i);
            for (Node node = element2.getFirstChild(); node != null; node = node.getNextSibling()) {
                Element element3;
                Bridge bridge;
                if (node.getNodeType() != 1 || (bridge = bridgeContext.getBridge(element3 = (Element)node)) == null || !(bridge instanceof GraphicsNodeBridge)) continue;
                return true;
            }
        }
        return false;
    }
}

