/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSKeyframeRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.w3c.dom.DOMException;

public class KeyframeRule
extends BaseCSSDeclarationRule
implements CSSKeyframeRule {
    private static final long serialVersionUID = 1L;
    private final KeyframesRule parentRule;
    private String keyText;

    public KeyframeRule(KeyframesRule keyframesRule) {
        super(keyframesRule.getParentStyleSheet(), (short)8, keyframesRule.getOrigin());
        this.parentRule = keyframesRule;
    }

    @Override
    public String getKeyText() {
        return this.keyText;
    }

    void setKeyText(String string) {
        this.keyText = string;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext styleFormattingContext = this.getStyleFormattingContext();
        styleFormattingContext.setParentContext(this.getParentRule());
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)bufferSimpleWriter, styleFormattingContext);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
        return bufferSimpleWriter.toString();
    }

    @Override
    public String getMinifiedCssText() {
        return this.getKeyText() + '{' + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext) throws IOException {
        styleFormattingContext.startRule(simpleWriter, this.getPrecedingComments());
        simpleWriter.write((CharSequence)this.getKeyText());
        styleFormattingContext.updateContext(this);
        styleFormattingContext.writeLeftCurlyBracket(simpleWriter);
        styleFormattingContext.startStyleDeclaration(simpleWriter);
        this.getStyle().writeCssText(simpleWriter, styleFormattingContext);
        styleFormattingContext.endCurrentContext(this);
        styleFormattingContext.endStyleDeclaration(simpleWriter);
        styleFormattingContext.writeRightCurlyBracket(simpleWriter);
        styleFormattingContext.endRule(simpleWriter, this.getTrailingComments());
    }

    @Override
    public void setCssText(String string) throws DOMException {
        MyKFHandler myKFHandler = new MyKFHandler();
        myKFHandler.setLexicalPropertyListener(this.getLexicalPropertyListener());
        StringReader stringReader = new StringReader(string);
        try {
            this.parseRule((Reader)stringReader, myKFHandler);
        }
        catch (IOException iOException) {
            throw new DOMException(11, iOException.getMessage());
        }
    }

    @Override
    void parseRule(Reader reader, CSSHandler cSSHandler) throws IOException {
        CSSParser cSSParser = (CSSParser)this.createSACParser();
        BaseCSSRule.AllowWarningsRuleErrorHandler allowWarningsRuleErrorHandler = new BaseCSSRule.AllowWarningsRuleErrorHandler();
        cSSParser.setDocumentHandler(cSSHandler);
        cSSParser.setErrorHandler(allowWarningsRuleErrorHandler);
        this.parseRule(reader, cSSParser);
    }

    @Override
    void parseRule(Reader reader, Parser parser) throws DOMException, IOException {
        try {
            ((CSSParser)parser).parseDeclarationRule(reader);
        }
        catch (CSSNamespaceParseException cSSNamespaceParseException) {
            DOMException dOMException = new DOMException(14, cSSNamespaceParseException.getMessage());
            dOMException.initCause(cSSNamespaceParseException);
            throw dOMException;
        }
        catch (CSSBudgetException cSSBudgetException) {
            DOMException dOMException = new DOMException(9, cSSBudgetException.getMessage());
            dOMException.initCause(cSSBudgetException);
            throw dOMException;
        }
        catch (CSSParseException cSSParseException) {
            DOMException dOMException = new DOMException(12, "Parse error at [" + cSSParseException.getLineNumber() + ',' + cSSParseException.getColumnNumber() + "]: " + cSSParseException.getMessage());
            dOMException.initCause(cSSParseException);
            throw dOMException;
        }
        catch (CSSException cSSException) {
            DOMException dOMException = new DOMException(15, cSSException.getMessage());
            dOMException.initCause(cSSException);
            throw dOMException;
        }
        catch (RuntimeException runtimeException) {
            Object object;
            String string = runtimeException.getMessage();
            AbstractCSSStyleSheet abstractCSSStyleSheet = this.getParentStyleSheet();
            if (abstractCSSStyleSheet != null && (object = abstractCSSStyleSheet.getHref()) != null) {
                string = "Error in stylesheet at " + (String)object + ": " + string;
            }
            object = new DOMException(11, string);
            ((Throwable)object).initCause(runtimeException);
            throw object;
        }
    }

    @Override
    public KeyframesRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parentRule.getParentStyleSheet();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.keyText == null ? 0 : this.keyText.hashCode());
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyframeRule keyframeRule = (KeyframeRule)object;
        return !(this.keyText == null ? keyframeRule.keyText != null : !this.keyText.equals(keyframeRule.keyText));
    }

    @Override
    public KeyframeRule clone(AbstractCSSStyleSheet abstractCSSStyleSheet) {
        KeyframeRule keyframeRule = new KeyframeRule(this.getParentRule());
        keyframeRule.setKeyText(this.getKeyText());
        String string = this.getParentStyleSheet().getHref();
        keyframeRule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), string);
        return keyframeRule;
    }

    private class MyKFHandler
    extends BaseCSSDeclarationRule.DeclarationRuleCSSHandler {
        private MyKFHandler() {
        }

        @Override
        public void startAtRule(String string, String string2) {
            String string3 = KeyframeRule.this.getParentRule().keyframeSelector(string2);
            KeyframeRule.this.setKeyText(string3);
        }

        @Override
        public void property(String string, LexicalUnit lexicalUnit, boolean bl) {
            if (bl) {
                CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Important declarations in a keyframe rule are not valid");
                cSSPropertyValueException.setValueText(lexicalUnit.toString() + " !important");
                KeyframeRule.this.getStyleDeclarationErrorHandler().wrongValue(string, cSSPropertyValueException);
            } else {
                super.property(string, lexicalUnit, bl);
            }
        }
    }
}

