/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSLab;
import org.w3c.css.om.typed.CSSNumericValue;
import org.w3c.dom.DOMException;

public class LabColorValue
extends ColorValue
implements CSSLab {
    private static final long serialVersionUID = 1L;
    protected NumericValue l;
    protected NumericValue a;
    protected NumericValue b;

    public LabColorValue(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3) throws DOMSyntaxException {
        this(numericValue, numericValue2, numericValue3, SVGValueConstants.NUMBER_1);
    }

    public LabColorValue(NumericValue numericValue, NumericValue numericValue2, NumericValue numericValue3, NumericValue numericValue4) throws DOMSyntaxException {
        super(numericValue4);
        this.setL(numericValue);
        this.setA(numericValue2);
        this.setB(numericValue3);
    }

    @Override
    public String getCSSColorSpace() {
        return "lab";
    }

    public String getCssText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("lab(").append(this.l.getCssText()).append(' ').append(this.a.getCssText()).append(' ').append(this.b.getCssText());
        if (!this.isOpaque()) {
            stringBuilder.append(' ').append(this.getAlpha().getCssText());
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public NumericValue getL() {
        return this.l;
    }

    public NumericValue getA() {
        return this.a;
    }

    public NumericValue getB() {
        return this.b;
    }

    public void setL(double d) {
        this.l = new FloatValue(2, (float)d);
        this.componentize(this.l);
        this.componentChanged(this.l);
    }

    public void setL(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.l = this.component(cSSNumericValue);
        this.componentChanged(this.l);
    }

    private NumericValue component(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        NumericValue numericValue = (NumericValue)cSSNumericValue;
        if (numericValue.getUnitType() != 2 && numericValue.getUnitType() != 0) {
            throw new DOMSyntaxException("Lab component must be a number or percentage.");
        }
        if (numericValue.handler != null) {
            numericValue = numericValue.clone();
        }
        this.componentize(numericValue);
        return numericValue;
    }

    public void setA(double d) {
        this.a = new FloatValue(0, (float)d);
        this.componentize(this.a);
        this.componentChanged(this.a);
    }

    public void setA(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.a = this.component(cSSNumericValue);
        this.componentChanged(this.a);
    }

    public void setB(double d) {
        this.b = new FloatValue(0, (float)d);
        this.componentize(this.b);
        this.componentChanged(this.b);
    }

    public void setB(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.b = this.component(cSSNumericValue);
        this.componentChanged(this.b);
    }

    @Override
    public int getLength() throws DOMException {
        return 4;
    }

    @Override
    public Value item(int n) throws DOMException {
        switch (n) {
            case 0: {
                return this.getL();
            }
            case 1: {
                return this.getA();
            }
            case 2: {
                return this.getB();
            }
            case 3: {
                return this.getAlpha();
            }
        }
        return null;
    }

    @Override
    public LabColorValue clone() {
        LabColorValue labColorValue = (LabColorValue)super.clone();
        labColorValue.l = this.l.clone();
        labColorValue.a = this.a.clone();
        labColorValue.b = this.b.clone();
        return labColorValue;
    }
}

