/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.css;

import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSContext;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.IdentValue;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.StringValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class FontFamilyManager
extends AbstractValueManager {
    protected static final ListValue DEFAULT_VALUE = FontFamilyManager.createDefaultValue();
    protected static final StringMap values = new StringMap();

    private static ListValue createDefaultValue() {
        ListValue listValue = new ListValue(',', 4);
        listValue.append(new StringValue("Arial"));
        listValue.append(new StringValue("Helvetica"));
        listValue.append(IdentValue.createConstant("sans-serif"));
        return listValue.createUnmodifiableView();
    }

    @Override
    public boolean isInheritedProperty() {
        return true;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 26;
    }

    @Override
    public String getPropertyName() {
        return "font-family";
    }

    @Override
    public Value getDefaultValue() {
        return DEFAULT_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lexicalUnit);
            }
            default: {
                throw this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
            }
            case IDENT: 
            case STRING: 
        }
        ListValue listValue = new ListValue();
        LexicalUnit lexicalUnit2 = lexicalUnit;
        do {
            switch (lexicalUnit2.getLexicalUnitType()) {
                case STRING: {
                    listValue.append(new StringValue(lexicalUnit2.getStringValue()));
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    break;
                }
                case IDENT: {
                    StringBuilder stringBuilder = new StringBuilder(lexicalUnit2.getStringValue());
                    lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                    if (lexicalUnit2 != null && this.isIdentOrNumber(lexicalUnit2)) {
                        do {
                            stringBuilder.append(' ');
                            switch (lexicalUnit2.getLexicalUnitType()) {
                                case IDENT: {
                                    stringBuilder.append(lexicalUnit2.getStringValue());
                                    break;
                                }
                                case INTEGER: {
                                    stringBuilder.append(Integer.toString(lexicalUnit2.getIntegerValue()));
                                }
                            }
                        } while ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null && this.isIdentOrNumber(lexicalUnit2));
                        listValue.append(new StringValue(stringBuilder.toString()));
                        break;
                    }
                    String string = stringBuilder.toString();
                    String string2 = string.toLowerCase(Locale.ROOT).intern();
                    Value value = (Value)values.get(string2);
                    listValue.append(value != null ? value : new StringValue(string));
                    break;
                }
                case VAR: 
                case ATTR: {
                    return this.createLexicalValue(lexicalUnit);
                }
            }
            if (lexicalUnit2 == null) {
                return listValue;
            }
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) continue;
            if (lexicalUnit2.getLexicalUnitType() == LexicalUnit.LexicalType.VAR) {
                return this.createLexicalValue(lexicalUnit);
            }
            throw this.createInvalidLexicalUnitDOMException(lexicalUnit2.getLexicalUnitType());
        } while ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null);
        throw this.createMalformedLexicalUnitDOMException();
    }

    private boolean isIdentOrNumber(LexicalUnit lexicalUnit) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        return lexicalType == LexicalUnit.LexicalType.IDENT || lexicalType == LexicalUnit.LexicalType.INTEGER;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value == DEFAULT_VALUE) {
            CSSContext cSSContext = cSSEngine.getCSSContext();
            value = cSSContext.getDefaultFontFamily();
        }
        return value;
    }

    static {
        values.put("cursive", ValueConstants.CURSIVE_VALUE);
        values.put("fantasy", ValueConstants.FANTASY_VALUE);
        values.put("monospace", ValueConstants.MONOSPACE_VALUE);
        values.put("serif", ValueConstants.SERIF_VALUE);
        values.put("sans-serif", ValueConstants.SANS_SERIF_VALUE);
    }
}

