/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.trogdor.workload.FlushGenerator;

public class ConstantFlushGenerator
implements FlushGenerator {
    private final int messagesPerFlush;
    private int messageTracker = 0;

    @JsonCreator
    public ConstantFlushGenerator(@JsonProperty(value="messagesPerFlush") int messagesPerFlush) {
        this.messagesPerFlush = messagesPerFlush;
    }

    @JsonProperty
    public int messagesPerFlush() {
        return this.messagesPerFlush;
    }

    @Override
    public synchronized <K, V> void increment(KafkaProducer<K, V> producer) {
        ++this.messageTracker;
        if (this.messageTracker >= this.messagesPerFlush) {
            this.messageTracker = 0;
            try {
                producer.flush();
            }
            catch (InterruptException interruptException) {
                // empty catch block
            }
        }
    }
}

