/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.authenticator;

import com.webauthn4j.authenticator.CoreAuthenticator;
import com.webauthn4j.data.CoreRegistrationData;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.RegistrationExtensionAuthenticatorOutput;
import com.webauthn4j.util.AssertUtil;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CoreAuthenticatorImpl
implements CoreAuthenticator {
    private static final String ATTESTED_CREDENTIAL_DATA_MUST_NOT_BE_NULL = "attestedCredentialData must not be null";
    private AttestedCredentialData attestedCredentialData;
    private AttestationStatement attestationStatement;
    private long counter;
    private AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions;

    public CoreAuthenticatorImpl(@NonNull AttestedCredentialData attestedCredentialData, @Nullable AttestationStatement attestationStatement, long counter, @Nullable AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions) {
        AssertUtil.notNull((Object)attestedCredentialData, (String)ATTESTED_CREDENTIAL_DATA_MUST_NOT_BE_NULL);
        this.attestedCredentialData = attestedCredentialData;
        this.attestationStatement = attestationStatement;
        this.setCounter(counter);
        this.authenticatorExtensions = authenticatorExtensions;
    }

    public static @NonNull CoreAuthenticatorImpl createFromCoreRegistrationData(@NonNull CoreRegistrationData coreRegistrationData) {
        AssertUtil.notNull((Object)coreRegistrationData.getAttestationObject(), (String)"attestationObject must not be null");
        AssertUtil.notNull(coreRegistrationData.getAttestationObject().getAuthenticatorData(), (String)"authenticatorData must not be null");
        AssertUtil.notNull((Object)coreRegistrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData(), (String)ATTESTED_CREDENTIAL_DATA_MUST_NOT_BE_NULL);
        return new CoreAuthenticatorImpl(coreRegistrationData.getAttestationObject().getAuthenticatorData().getAttestedCredentialData(), coreRegistrationData.getAttestationObject().getAttestationStatement(), coreRegistrationData.getAttestationObject().getAuthenticatorData().getSignCount(), coreRegistrationData.getAttestationObject().getAuthenticatorData().getExtensions());
    }

    @Override
    public @NonNull AttestedCredentialData getAttestedCredentialData() {
        return this.attestedCredentialData;
    }

    public void setAttestedCredentialData(@NonNull AttestedCredentialData attestedCredentialData) {
        AssertUtil.notNull((Object)attestedCredentialData, (String)ATTESTED_CREDENTIAL_DATA_MUST_NOT_BE_NULL);
        this.attestedCredentialData = attestedCredentialData;
    }

    @Override
    public @Nullable AttestationStatement getAttestationStatement() {
        return this.attestationStatement;
    }

    public void setAttestationStatement(@Nullable AttestationStatement attestationStatement) {
        this.attestationStatement = attestationStatement;
    }

    @Override
    public long getCounter() {
        return this.counter;
    }

    @Override
    public void setCounter(long value) {
        if (value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is unsigned int. it must not exceed 4294967295.");
        }
        if (value < 0L) {
            throw new IllegalArgumentException("[Assertion failed] - this argument is unsigned int. it must not be negative value.");
        }
        this.counter = value;
    }

    @Override
    public @Nullable AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> getAuthenticatorExtensions() {
        return this.authenticatorExtensions;
    }

    public void setAuthenticatorExtensions(@Nullable AuthenticationExtensionsAuthenticatorOutputs<RegistrationExtensionAuthenticatorOutput> authenticatorExtensions) {
        this.authenticatorExtensions = authenticatorExtensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoreAuthenticatorImpl that = (CoreAuthenticatorImpl)o;
        return this.counter == that.counter && Objects.equals(this.attestedCredentialData, that.attestedCredentialData) && Objects.equals(this.attestationStatement, that.attestationStatement) && Objects.equals(this.authenticatorExtensions, that.authenticatorExtensions);
    }

    public int hashCode() {
        return Objects.hash(this.attestedCredentialData, this.attestationStatement, this.counter, this.authenticatorExtensions);
    }
}

