/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.SingleUseObjectProvider;
import org.keycloak.protocol.oidc.endpoints.AuthorizationEndpoint;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequest;
import org.keycloak.protocol.oidc.endpoints.request.AuthorizationEndpointRequestParserProcessor;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestObjectParser;
import org.keycloak.protocol.oidc.endpoints.request.AuthzEndpointRequestParser;
import org.keycloak.protocol.oidc.endpoints.request.RequestUriType;
import org.keycloak.protocol.oidc.par.endpoints.ParEndpoint;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.PreAuthorizationRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class SecureParContentsExecutor
implements ClientPolicyExecutorProvider<ClientPolicyExecutorConfigurationRepresentation> {
    protected final KeycloakSession session;
    private static final Logger logger = Logger.getLogger(SecureParContentsExecutor.class);

    public SecureParContentsExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "secure-par-content";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case PRE_AUTHORIZATION_REQUEST: {
                PreAuthorizationRequestContext preAuthorizationRequestContext = (PreAuthorizationRequestContext)context;
                this.checkValidParContents(preAuthorizationRequestContext);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void checkValidParContents(PreAuthorizationRequestContext preAuthorizationRequestContext) throws ClientPolicyException {
        MultivaluedMap<String, String> requestParametersFromQuery = preAuthorizationRequestContext.getRequestParameters();
        String requestUri = (String)requestParametersFromQuery.getFirst((Object)"request_uri");
        if (requestUri == null) {
            throw new ClientPolicyException("invalid_request", "request_uri not included.");
        }
        if (requestUri != null && AuthorizationEndpointRequestParserProcessor.getRequestUriType(requestUri) != RequestUriType.PAR) {
            throw new ClientPolicyException("invalid_request", "PAR request_uri not included.");
        }
        String key = requestUri.substring(ParEndpoint.REQUEST_URI_PREFIX_LENGTH);
        SingleUseObjectProvider singleUseStore = this.session.singleUseObjects();
        Map requestParametersFromPAR = singleUseStore.get(key);
        if (requestParametersFromPAR == null) {
            throw new ClientPolicyException("invalid_request", "PAR not found. not issued or used multiple times.");
        }
        Set<Object> requestParametersNameFromPAR = new HashSet();
        requestParametersNameFromPAR = requestParametersFromPAR.containsKey("request") ? this.getParRetrievedRequestParameters(requestParametersFromPAR, preAuthorizationRequestContext.getClientId()) : requestParametersFromPAR.keySet();
        for (String queryParamName : requestParametersFromQuery.keySet()) {
            if (requestParametersNameFromPAR.contains(queryParamName) || "request_uri".equals(queryParamName)) continue;
            singleUseStore.remove(key);
            throw new ClientPolicyException("invalid_request", "PAR request did not include necessary parameters");
        }
    }

    private Set<String> getParRetrievedRequestParameters(Map<String, String> requestParametersFromPAR, String clientId) {
        AuthorizationEndpointRequest request = new AuthorizationEndpointRequest();
        HashSet<String> parRetrievedRequest = new HashSet<String>();
        String requestObjectString = requestParametersFromPAR.get("request");
        RealmModel realm = this.session.getContext().getRealm();
        ClientModel client = realm.getClientByClientId(clientId);
        new AuthzEndpointRequestObjectParser(this.session, requestObjectString, client).parseRequest(request);
        for (String param : requestParametersFromPAR.keySet()) {
            if ("request".equals(param)) continue;
            parRetrievedRequest.add(param);
        }
        AuthorizationEndpoint.performActionOnParameters(request, (paramName, paramValue) -> {
            if (paramValue != null) {
                parRetrievedRequest.add((String)paramName);
            }
        });
        if (request.getClientId() != null) {
            parRetrievedRequest.add("client_id");
        }
        if (request.getResponseType() != null) {
            parRetrievedRequest.add("response_type");
        }
        if (request.getRedirectUriParam() != null) {
            parRetrievedRequest.add("redirect_uri");
        }
        if (request.getMaxAge() != null) {
            parRetrievedRequest.add("max_age");
        }
        if (request.getUiLocales() != null) {
            parRetrievedRequest.add("ui_locales");
        }
        for (String additionalParam : request.getAdditionalReqParams().keySet()) {
            if (AuthzEndpointRequestParser.KNOWN_REQ_PARAMS.contains(additionalParam)) continue;
            parRetrievedRequest.add(additionalParam);
        }
        return parRetrievedRequest;
    }
}

