/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.models.ClientModel;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.services.resources.admin.permissions.RealmPermissions;

class RealmPermissionsV2
extends RealmPermissions {
    public RealmPermissionsV2(MgmtPermissions root) {
        super(root);
    }

    @Override
    public boolean canManageAuthorizationDefault(ResourceServer resourceServer) {
        if (resourceServer == null) {
            return super.canManageAuthorizationDefault(resourceServer);
        }
        return this.root.clients().canManage(this.getClient(resourceServer));
    }

    @Override
    public boolean canViewAuthorizationDefault(ResourceServer resourceServer) {
        if (resourceServer == null) {
            return super.canViewAuthorizationDefault(resourceServer);
        }
        return this.root.clients().canView(this.getClient(resourceServer));
    }

    private ClientModel getClient(ResourceServer resourceServer) {
        ClientModel client = this.root.session.clients().getClientById(this.root.realm, resourceServer.getId());
        return client;
    }
}

