/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.protostream.schema.CommentContainer;
import org.infinispan.protostream.schema.Enum;
import org.infinispan.protostream.schema.Message;
import org.infinispan.protostream.schema.OptionContainer;
import org.infinispan.protostream.schema.ReservedContainer;
import org.infinispan.protostream.schema.Schema;

public class EnumValue {
    private final String name;
    private final String fullName;
    private final int number;
    private final List<String> comments;
    private final Map<String, Object> options;

    public EnumValue(Builder builder, AtomicInteger autoNumber) {
        this.name = builder.name;
        this.fullName = builder.getFullName();
        this.number = builder.number < 0 ? autoNumber.getAndIncrement() : builder.number;
        this.comments = List.copyOf(builder.comments);
        this.options = Map.copyOf(builder.options);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public int getNumber() {
        return this.number;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public static class Builder
    implements OptionContainer<Builder>,
    CommentContainer<Builder>,
    ReservedContainer<Enum.Builder> {
        final String name;
        final int number;
        private final Enum.Builder parent;
        private final List<String> comments = new ArrayList<String>();
        private final Map<String, Object> options = new HashMap<String, Object>();

        Builder(Enum.Builder parent, String name, int number) {
            this.parent = parent;
            this.name = name;
            this.number = number;
        }

        EnumValue create(AtomicInteger autoNumber) {
            return new EnumValue(this, autoNumber);
        }

        @Override
        public Schema build() {
            return this.parent.build();
        }

        @Override
        public String getFullName() {
            return this.parent.getFullName() + "." + this.name;
        }

        @Override
        public Builder addOption(String name, Object value) {
            this.options.put(name, value);
            return this;
        }

        public Builder addValue(String name) {
            return this.addValue(name, -1);
        }

        public Builder addValue(String name, int number) {
            return this.parent.addValue(name, number);
        }

        public Message.Builder addMessage(String name) {
            return this.parent.addMessage(name);
        }

        @Override
        public Builder addComment(String comment) {
            Objects.requireNonNull(comment, "comment must not be null");
            this.comments.add(comment.trim());
            return this;
        }

        @Override
        public Enum.Builder addReserved(int ... numbers) {
            return this.parent.addReserved(numbers);
        }

        @Override
        public Enum.Builder addReservedRange(int from, int to) {
            return this.parent.addReservedRange(from, to);
        }

        @Override
        public Enum.Builder addReserved(String name) {
            return this.parent.addReserved(name);
        }
    }
}

