/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.subscription.UniEmitter;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class UniOnNotNull<T> {
    private final Uni<T> upstream;

    public UniOnNotNull(Uni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    @CheckReturnValue
    public Uni<T> invoke(Consumer<? super T> callback) {
        Consumer actual = Infrastructure.decorate(ParameterValidation.nonNull(callback, "callback"));
        return this.upstream.onItem().invoke((? super T item) -> {
            if (item != null) {
                actual.accept(item);
            }
        });
    }

    @CheckReturnValue
    public Uni<T> invoke(Runnable callback) {
        Runnable runnable = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((? super T x) -> runnable.run());
    }

    @CheckReturnValue
    public Uni<T> call(Function<? super T, Uni<?>> action) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.upstream.onItem().call((? super T item) -> {
            if (item != null) {
                return (Uni)actual.apply(item);
            }
            return Uni.createFrom().nullItem();
        });
    }

    @CheckReturnValue
    public Uni<T> call(Supplier<Uni<?>> action) {
        Supplier<Uni<?>> actual = Infrastructure.decorate(ParameterValidation.nonNull(action, "action"));
        return this.call((? super T ignored) -> (Uni)actual.get());
    }

    @CheckReturnValue
    public <R> Uni<R> transform(Function<? super T, ? extends R> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.upstream.onItem().transform(item -> {
            if (item != null) {
                return actual.apply(item);
            }
            return null;
        });
    }

    @CheckReturnValue
    public <R> Uni<R> transformToUni(Function<? super T, Uni<? extends R>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.upstream.onItem().transformToUni((? super T item) -> {
            if (item != null) {
                return (Uni)actual.apply(item);
            }
            return Uni.createFrom().nullItem();
        });
    }

    @CheckReturnValue
    public <R> Multi<R> transformToMulti(Function<? super T, ? extends Flow.Publisher<? extends R>> mapper) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(mapper, "mapper"));
        return this.upstream.onItem().transformToMulti(item -> {
            if (item != null) {
                return (Flow.Publisher)actual.apply(item);
            }
            return Multi.createFrom().empty();
        });
    }

    @CheckReturnValue
    public <R> Uni<R> transformToUni(BiConsumer<? super T, UniEmitter<? super R>> consumer) {
        BiConsumer actual = Infrastructure.decorate(ParameterValidation.nonNull(consumer, "consumer"));
        return this.upstream.onItem().transformToUni((? super T item, UniEmitter<? super R> emitter) -> {
            if (item != null) {
                actual.accept((Object)item, (UniEmitter)emitter);
            } else {
                emitter.complete(null);
            }
        });
    }

    @CheckReturnValue
    public Uni<T> failWith(Supplier<? extends Throwable> supplier) {
        Supplier<? extends Throwable> actual = Infrastructure.decorate(ParameterValidation.nonNull(supplier, "supplier"));
        return this.transformToUni((? super T ignored) -> {
            Throwable failure = ParameterValidation.nonNull((Throwable)actual.get(), "supplier");
            return Uni.createFrom().failure(failure);
        });
    }

    @CheckReturnValue
    public Uni<T> failWith(Throwable failure) {
        ParameterValidation.nonNull(failure, "failure");
        return this.failWith(() -> failure);
    }
}

