/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.authorization;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@VertxGen
public interface AuthorizationProvider {
    public static AuthorizationProvider create(final String id, Set<Authorization> authorizations) {
        final HashSet _authorizations = new HashSet(Objects.requireNonNull(authorizations));
        return new AuthorizationProvider(){

            @Override
            public String getId() {
                return id;
            }

            @Override
            public void getAuthorizations(User user, Handler<AsyncResult<Void>> handler) {
                this.getAuthorizations(user).onComplete(handler);
            }

            @Override
            public Future<Void> getAuthorizations(User user) {
                user.authorizations().add(this.getId(), _authorizations);
                return Future.succeededFuture();
            }
        };
    }

    public String getId();

    public void getAuthorizations(User var1, Handler<AsyncResult<Void>> var2);

    default public Future<Void> getAuthorizations(User user) {
        Promise promise = Promise.promise();
        this.getAuthorizations(user, (Handler<AsyncResult<Void>>)promise);
        return promise.future();
    }
}

