/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ImportProvider;

public abstract class AbstractFileBasedImportProvider
implements ImportProvider {
    private static final StringPropertyReplacer.PropertyResolver ENV_VAR_PROPERTY_RESOLVER = new StringPropertyReplacer.PropertyResolver(){

        public String resolve(String property) {
            return Optional.ofNullable(property).map(System::getenv).orElse(null);
        }
    };

    protected InputStream parseFile(File importFile) throws IOException {
        if (ExportImportConfig.isReplacePlaceholders()) {
            return StringPropertyReplacer.replaceProperties((InputStream)new BufferedInputStream(new FileInputStream(importFile)), (StringPropertyReplacer.PropertyResolver)ENV_VAR_PROPERTY_RESOLVER);
        }
        return new FileInputStream(importFile);
    }
}

