/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffprobe.FFprobe;
import com.github.kokorin.jaffree.ffprobe.FFprobeResult;
import com.github.kokorin.jaffree.ffprobe.Stream;
import com.github.kokorin.jaffree.log.LogMessage;
import com.github.kokorin.jaffree.process.JaffreeAbnormalExitException;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.config.Daten;
import mediathek.config.MVColor;
import mediathek.config.MVConfig;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenFilm;
import mediathek.daten.DatenPset;
import mediathek.daten.FilmResolution;
import mediathek.daten.ListePset;
import mediathek.gui.messages.DownloadListChangedEvent;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FileDialogs;
import mediathek.tool.FileUtils;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MessageBus;
import mediathek.tool.SVGIconUtilities;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXBusyLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogAddDownload
extends JDialog {
    private static final Logger logger = LogManager.getLogger();
    private static final String NO_DATA_AVAILABLE = "Keine Daten verf\u00fcgbar.";
    private static final String KEY_LABEL_FOREGROUND = "Label.foreground";
    private static final String KEY_TEXTFIELD_BACKGROUND = "TextField.background";
    private static final String TITLED_BORDER_STRING = "Download-Qualit\u00e4t";
    private final DatenFilm film;
    private final Optional<FilmResolution.Enum> requestedResolution;
    private final ListePset listeSpeichern = Daten.listePset.getListeSpeichern();
    private DatenPset active_pSet;
    private DatenDownload datenDownload;
    private String orgPfad = "";
    private String dateiGroesse_HQ = "";
    private String dateiGroesse_Hoch = "";
    private String dateiGroesse_Klein = "";
    private boolean nameGeaendert;
    private boolean stopBeob;
    private JTextComponent cbPathTextComponent;
    private Path ffprobePath;
    private ListenableFuture<FFprobeResult> resultListenableFuture;
    private ListenableFuture<String> hqFuture;
    private ListenableFuture<String> hochFuture;
    private ListenableFuture<String> kleinFuture;
    private boolean restoreFetchSize;
    private boolean highQualityMandated;
    private JButton btnRequestLiveInfo;
    private JButton jButtonAbbrechen;
    private JButton jButtonDelHistory;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JCheckBox jCheckBoxInfodatei;
    private JCheckBox jCheckBoxPfadSpeichern;
    private JCheckBox jCheckBoxStarten;
    private JCheckBox jCheckBoxSubtitle;
    private JComboBox<String> jComboBoxPfad;
    private JComboBox<String> jComboBoxPset;
    private JPanel jPanelSize;
    private JRadioButton jRadioButtonAufloesungHd;
    private JRadioButton jRadioButtonAufloesungHoch;
    private JRadioButton jRadioButtonAufloesungKlein;
    private JTextField jTextFieldName;
    private JTextField jTextFieldSender;
    private JLabel lblAudioInfo;
    private JXBusyLabel lblBusyIndicator;
    private JLabel lblStatus;

    public DialogAddDownload(@NotNull Frame parent, @NotNull DatenFilm film, @Nullable DatenPset pSet, @NotNull Optional<FilmResolution.Enum> requestedResolution) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.jButtonOk);
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.requestedResolution = requestedResolution;
        this.film = film;
        this.active_pSet = pSet;
        this.setupUI();
        if (SystemUtils.IS_OS_MAC_OSX) {
            this.pack();
        }
        this.restoreWindowSizeFromConfig();
        this.setLocationRelativeTo(parent);
        this.addComponentListener(new DialogPositionComponentListener());
    }

    public static void setModelPfad(String pfad, JComboBox<String> jcb) {
        ArrayList<String> pfade = new ArrayList<String>();
        boolean showLastUsedPath = ApplicationConfiguration.getConfiguration().getBoolean("download.path.last_used.show", true);
        if (!showLastUsedPath && !pfad.isEmpty()) {
            pfade.add(pfad);
        }
        if (!MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN).isEmpty()) {
            String[] p;
            for (String s : p = MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN).split("<>")) {
                if (pfade.contains(s)) continue;
                pfade.add(s);
            }
        }
        if (showLastUsedPath && !pfad.isEmpty() && !pfade.contains(pfad)) {
            pfade.add(pfad);
        }
        jcb.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[0])));
    }

    public static void saveComboPfad(JComboBox<String> jcb, String orgPath) {
        ArrayList<String> pfade = new ArrayList<String>();
        String s = Objects.requireNonNull(jcb.getSelectedItem()).toString();
        if (!s.equals(orgPath) || ApplicationConfiguration.getConfiguration().getBoolean("download.path.last_used.show", true)) {
            pfade.add(s);
        }
        for (int i = 0; i < jcb.getItemCount(); ++i) {
            s = jcb.getItemAt(i);
            if (s.equals(orgPath) || pfade.contains(s)) continue;
            pfade.add(s);
        }
        if (!pfade.isEmpty()) {
            s = pfade.stream().filter(pfad -> !pfad.isEmpty()).limit(15L).collect(Collectors.joining("<>"));
        }
        MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreWindowSizeFromConfig() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int width = config.getInt("application.ui.adddownload_dialog.width");
            int height = config.getInt("application.ui.adddownload_dialog.height");
            int x = config.getInt("application.ui.adddownload_dialog.location.x");
            int y = config.getInt("application.ui.adddownload_dialog.location.y");
            this.setBounds(x, y, width, height);
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    private void setupFilmQualityRadioButtons() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogAddDownload.this.setNameFilm();
                DialogAddDownload.this.lblStatus.setText("");
                DialogAddDownload.this.lblAudioInfo.setText("");
                DialogAddDownload.this.lblBusyIndicator.setBusy(false);
                DialogAddDownload.this.lblBusyIndicator.setVisible(false);
                if (DialogAddDownload.this.resultListenableFuture != null) {
                    DialogAddDownload.this.resultListenableFuture.cancel(true);
                    DialogAddDownload.this.resultListenableFuture = null;
                }
            }
        };
        this.jRadioButtonAufloesungHd.addActionListener(listener);
        this.jRadioButtonAufloesungHd.setEnabled(!this.film.getHighQualityUrl().isEmpty());
        this.jRadioButtonAufloesungKlein.addActionListener(listener);
        this.jRadioButtonAufloesungKlein.setEnabled(!this.film.getLowQualityUrl().isEmpty());
        this.jRadioButtonAufloesungHoch.addActionListener(listener);
        this.jRadioButtonAufloesungHoch.setSelected(true);
        this.btnRequestLiveInfo.addActionListener(l -> this.handleRequestLiveFilmInfo());
    }

    private String getVideoCodecName(@NotNull Stream stream) {
        String name = stream.getCodecLongName();
        logger.trace("video codec long name: {}", (Object)name);
        try {
            String[] splitName = name.split("/");
            return splitName[0].trim();
        }
        catch (Exception e) {
            return name;
        }
    }

    private void handleRequestLiveFilmInfo() {
        FilmResolution.Enum res = this.getFilmResolution();
        String url = this.film.getUrlFuerAufloesung(res);
        this.btnRequestLiveInfo.setEnabled(false);
        this.lblBusyIndicator.setVisible(true);
        this.lblBusyIndicator.setBusy(true);
        this.lblStatus.setText("");
        this.lblAudioInfo.setText("");
        Future resultFuture = FFprobe.atPath((Path)this.ffprobePath).setShowStreams(true).setInput(url).executeAsync();
        this.resultListenableFuture = JdkFutureAdapters.listenInPoolThread((Future)resultFuture);
        Futures.addCallback(this.resultListenableFuture, (FutureCallback)new FutureCallback<FFprobeResult>(){
            private static final String ERR_MSG_PART = "Server returned ";
            private static final String MSG_UNKNOWN_ERROR = "Unbekannter Fehler aufgetreten.";

            public void onSuccess(FFprobeResult result) {
                Optional<Stream> audioStreamResult = result.getStreams().stream().filter(stream -> stream.getCodecType() == StreamType.AUDIO).findAny();
                audioStreamResult.ifPresentOrElse(astream -> {
                    Integer sample_rate = astream.getSampleRate();
                    String audio_output = this.getAudioInfo((Stream)astream, sample_rate);
                    SwingUtilities.invokeLater(() -> {
                        DialogAddDownload.this.lblAudioInfo.setForeground(UIManager.getColor(DialogAddDownload.KEY_LABEL_FOREGROUND));
                        DialogAddDownload.this.lblAudioInfo.setText(audio_output);
                    });
                }, () -> SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.lblAudioInfo.setForeground(UIManager.getColor(DialogAddDownload.KEY_LABEL_FOREGROUND));
                    DialogAddDownload.this.lblAudioInfo.setText(DialogAddDownload.NO_DATA_AVAILABLE);
                }));
                Optional<Stream> videoStreamResult = result.getStreams().stream().filter(stream -> stream.getCodecType() == StreamType.VIDEO).findAny();
                videoStreamResult.ifPresentOrElse(stream -> {
                    int frame_rate = stream.getAvgFrameRate().intValue();
                    String codecName = DialogAddDownload.this.getVideoCodecName((Stream)stream);
                    String video_output = this.getVideoInfoString((Stream)stream, frame_rate, codecName);
                    SwingUtilities.invokeLater(() -> {
                        DialogAddDownload.this.lblStatus.setForeground(UIManager.getColor(DialogAddDownload.KEY_LABEL_FOREGROUND));
                        DialogAddDownload.this.lblStatus.setText(video_output);
                    });
                }, () -> SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.lblStatus.setForeground(UIManager.getColor(DialogAddDownload.KEY_LABEL_FOREGROUND));
                    DialogAddDownload.this.lblStatus.setText(DialogAddDownload.NO_DATA_AVAILABLE);
                }));
                SwingUtilities.invokeLater(() -> DialogAddDownload.this.resetBusyLabelAndButton());
            }

            private int safe_process_bit_rate(Integer in) {
                int bits;
                try {
                    bits = in / 1000;
                }
                catch (Exception e) {
                    bits = 0;
                }
                return bits;
            }

            private String getVideoInfoString(Stream stream, int frame_rate, String codecName) {
                int bit_rate = this.safe_process_bit_rate(stream.getBitRate());
                String video_output = bit_rate == 0 ? String.format("Video: %dx%d, %d fps (avg), %s", stream.getWidth(), stream.getHeight(), frame_rate, codecName) : String.format("Video: %dx%d, %d kBit/s, %d fps (avg), %s", stream.getWidth(), stream.getHeight(), bit_rate, frame_rate, codecName);
                return video_output;
            }

            private String getAudioInfo(Stream astream, Integer sample_rate) {
                int bits_per_sample = this.safe_process_bit_rate(astream.getBitRate());
                String audio_output = bits_per_sample == 0 ? String.format("Audio: %d Hz, %s", sample_rate, astream.getCodecLongName()) : String.format("Audio: %d Hz, %d kBit/s, %s", sample_rate, bits_per_sample, astream.getCodecLongName());
                return audio_output;
            }

            public void onFailure(@NotNull Throwable t) {
                if (t instanceof CancellationException) {
                    SwingUtilities.invokeLater(() -> {
                        DialogAddDownload.this.lblStatus.setText("");
                        DialogAddDownload.this.lblAudioInfo.setText("");
                        DialogAddDownload.this.resetBusyLabelAndButton();
                    });
                } else if (t instanceof JaffreeAbnormalExitException) {
                    JaffreeAbnormalExitException e = (JaffreeAbnormalExitException)t;
                    String final_str = this.getJaffreeErrorString(e);
                    this.setupLabels(final_str);
                } else {
                    this.setupLabels(MSG_UNKNOWN_ERROR);
                }
            }

            private void setupLabels(String text) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.lblStatus.setText(text);
                    DialogAddDownload.this.lblStatus.setForeground(Color.RED);
                    DialogAddDownload.this.lblAudioInfo.setText("");
                    DialogAddDownload.this.resetBusyLabelAndButton();
                });
            }

            @NotNull
            private String getJaffreeErrorString(JaffreeAbnormalExitException e) {
                String final_str;
                try {
                    String[] msg = ((LogMessage)e.getProcessErrorLogMessages().getFirst()).message.split(":");
                    String err_msg = msg[msg.length - 1].trim();
                    final_str = err_msg.startsWith(ERR_MSG_PART) ? err_msg.substring(ERR_MSG_PART.length()) : MSG_UNKNOWN_ERROR;
                }
                catch (Exception ignored) {
                    final_str = MSG_UNKNOWN_ERROR;
                }
                return final_str;
            }
        }, (Executor)Daten.getInstance().getDecoratedPool());
    }

    private void resetBusyLabelAndButton() {
        this.lblBusyIndicator.setBusy(false);
        this.lblBusyIndicator.setVisible(false);
        this.btnRequestLiveInfo.setEnabled(true);
    }

    private void detectFfprobeExecutable() {
        try {
            this.ffprobePath = GuiFunktionenProgramme.findExecutableOnPath("ffprobe").getParent();
        }
        catch (Exception ex) {
            logger.error("ffprobe not found", (Throwable)ex);
            this.lblBusyIndicator.setText("Hilfsprogramm nicht gefunden!");
            this.lblBusyIndicator.setForeground(Color.RED);
            this.btnRequestLiveInfo.setEnabled(false);
        }
    }

    private void setupBusyIndicator() {
        this.lblBusyIndicator.setText("");
        this.lblBusyIndicator.setBusy(false);
        this.lblBusyIndicator.setVisible(false);
        this.lblStatus.setText("");
        this.lblAudioInfo.setText("");
    }

    private void setupUI() {
        this.setupBusyIndicator();
        this.detectFfprobeExecutable();
        this.launchResolutionFutures();
        this.jCheckBoxStarten.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN)));
        this.jCheckBoxStarten.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_D_STARTEN, String.valueOf(this.jCheckBoxStarten.isSelected())));
        this.setupZielButton();
        this.jButtonOk.addActionListener(e -> {
            if (this.check()) {
                DialogAddDownload.saveComboPfad(this.jComboBoxPfad, this.orgPfad);
                this.saveDownload();
            }
        });
        this.jButtonAbbrechen.addActionListener(e -> this.dispose());
        this.setupPSetComboBox();
        this.setupSenderTextField();
        this.setupNameTextField();
        this.setupPathTextComponent();
        this.setupFilmQualityRadioButtons();
        this.setupDeleteHistoryButton();
        this.setupPfadSpeichernCheckBox();
        this.waitForFileSizeFutures();
        this.setupResolutionButtons();
        this.setupInfoFileCreationCheckBox();
        this.calculateAndCheckDiskSpace();
        this.nameGeaendert = false;
    }

    private void launchResolutionFutures() {
        this.restoreFetchSize = ApplicationConfiguration.getConfiguration().getBoolean("download.fetch_file_size", true);
        ApplicationConfiguration.getConfiguration().setProperty("download.fetch_file_size", (Object)true);
        ListeningExecutorService decoratedPool = Daten.getInstance().getDecoratedPool();
        this.hqFuture = decoratedPool.submit(() -> {
            String url = this.film.getUrlFuerAufloesung(FilmResolution.Enum.HIGH_QUALITY);
            return this.film.getFileSizeForUrl(url);
        });
        Futures.addCallback(this.hqFuture, (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(String result) {
                SwingUtilities.invokeLater(() -> {
                    if (DialogAddDownload.this.jRadioButtonAufloesungHd.isEnabled()) {
                        DialogAddDownload.this.dateiGroesse_HQ = result;
                        if (!DialogAddDownload.this.dateiGroesse_HQ.isEmpty()) {
                            String text = DialogAddDownload.this.jRadioButtonAufloesungHd.getText();
                            DialogAddDownload.this.jRadioButtonAufloesungHd.setText(text + "   [ " + DialogAddDownload.this.dateiGroesse_HQ + " MB ]");
                        }
                    }
                });
            }

            public void onFailure(@NotNull Throwable t) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.dateiGroesse_HQ = "";
                    logger.error("Failed to retrieve HD resolution", t);
                });
            }
        }, (Executor)decoratedPool);
        this.hochFuture = decoratedPool.submit(() -> {
            String url = this.film.getUrlNormalQuality();
            return this.film.getFileSizeForUrl(url);
        });
        Futures.addCallback(this.hochFuture, (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(String result) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.dateiGroesse_Hoch = result;
                    if (!DialogAddDownload.this.dateiGroesse_Hoch.isEmpty()) {
                        String text = DialogAddDownload.this.jRadioButtonAufloesungHoch.getText();
                        DialogAddDownload.this.jRadioButtonAufloesungHoch.setText(text + "   [ " + DialogAddDownload.this.dateiGroesse_Hoch + " MB ]");
                    }
                });
            }

            public void onFailure(@NotNull Throwable t) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.dateiGroesse_Hoch = "";
                    logger.error("Failed to retrieve Hoch resolution", t);
                });
            }
        }, (Executor)decoratedPool);
        this.kleinFuture = decoratedPool.submit(() -> {
            String url = this.film.getUrlFuerAufloesung(FilmResolution.Enum.LOW);
            return this.film.getFileSizeForUrl(url);
        });
        Futures.addCallback(this.kleinFuture, (FutureCallback)new FutureCallback<String>(){

            public void onSuccess(String result) {
                SwingUtilities.invokeLater(() -> {
                    if (DialogAddDownload.this.jRadioButtonAufloesungKlein.isEnabled()) {
                        DialogAddDownload.this.dateiGroesse_Klein = result;
                        if (!DialogAddDownload.this.dateiGroesse_Klein.isEmpty()) {
                            String text = DialogAddDownload.this.jRadioButtonAufloesungKlein.getText();
                            DialogAddDownload.this.jRadioButtonAufloesungKlein.setText(text + "   [ " + DialogAddDownload.this.dateiGroesse_Klein + " MB ]");
                        }
                    }
                });
            }

            public void onFailure(@NotNull Throwable t) {
                SwingUtilities.invokeLater(() -> {
                    DialogAddDownload.this.dateiGroesse_Klein = "";
                    logger.error("Failed to retrieve Klein resolution", t);
                });
            }
        }, (Executor)decoratedPool);
    }

    private DefaultComboBoxModel<String> createPSetComboBoxModel() {
        return new DefaultComboBoxModel<String>(this.listeSpeichern.getObjectDataCombo());
    }

    private void setupPSetComboBox() {
        if (this.listeSpeichern.size() == 1) {
            this.jComboBoxPset.setEnabled(false);
        }
        DefaultComboBoxModel<String> model = this.createPSetComboBoxModel();
        this.jComboBoxPset.setModel(model);
        if (this.active_pSet != null) {
            this.jComboBoxPset.setSelectedItem(this.active_pSet.getName());
        } else {
            this.active_pSet = (DatenPset)this.listeSpeichern.get(this.jComboBoxPset.getSelectedIndex());
        }
        this.jComboBoxPset.addActionListener(e -> this.setupResolutionButtons());
    }

    private void setupSenderTextField() {
        this.jTextFieldSender.setText(" " + this.film.getSender() + ":   " + this.film.getTitle());
        this.jTextFieldSender.setBackground(UIManager.getColor("Label.background"));
    }

    private void setupNameTextField() {
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                if (!DialogAddDownload.this.stopBeob) {
                    DialogAddDownload.this.nameGeaendert = true;
                    if (!DialogAddDownload.this.jTextFieldName.getText().equals(FilenameUtils.checkDateiname(DialogAddDownload.this.jTextFieldName.getText(), false))) {
                        DialogAddDownload.this.jTextFieldName.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                    } else {
                        DialogAddDownload.this.jTextFieldName.setBackground(UIManager.getDefaults().getColor(DialogAddDownload.KEY_TEXTFIELD_BACKGROUND));
                    }
                }
            }
        });
    }

    private void setupPathTextComponent() {
        this.cbPathTextComponent = (JTextComponent)this.jComboBoxPfad.getEditor().getEditorComponent();
        this.cbPathTextComponent.setOpaque(true);
        this.cbPathTextComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                if (!DialogAddDownload.this.stopBeob) {
                    DialogAddDownload.this.nameGeaendert = true;
                    if (!SystemUtils.IS_OS_WINDOWS) {
                        String s = DialogAddDownload.this.cbPathTextComponent.getText();
                        Component editor = DialogAddDownload.this.jComboBoxPfad.getEditor().getEditorComponent();
                        if (!s.equals(FilenameUtils.checkDateiname(s, true))) {
                            editor.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                        } else {
                            editor.setBackground(UIManager.getColor(DialogAddDownload.KEY_TEXTFIELD_BACKGROUND));
                        }
                    }
                    DialogAddDownload.this.calculateAndCheckDiskSpace();
                }
            }
        });
    }

    private void setupZielButton() {
        this.jButtonZiel.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jButtonZiel.setText("");
        this.jButtonZiel.addActionListener(l -> {
            File directory;
            String initialDirectory = "";
            if (!Objects.requireNonNull(this.jComboBoxPfad.getSelectedItem()).toString().isEmpty()) {
                initialDirectory = this.jComboBoxPfad.getSelectedItem().toString();
            }
            if ((directory = FileDialogs.chooseDirectoryLocation(MediathekGui.ui(), "Film speichern", initialDirectory)) != null) {
                String selectedDirectory = directory.getAbsolutePath();
                this.jComboBoxPfad.addItem(selectedDirectory);
                this.jComboBoxPfad.setSelectedItem(selectedDirectory);
            }
        });
    }

    private void setupDeleteHistoryButton() {
        this.jButtonDelHistory.setText("");
        this.jButtonDelHistory.setIcon((Icon)SVGIconUtilities.createSVGIcon("icons/fontawesome/trash-can.svg"));
        this.jButtonDelHistory.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD__PFADE_ZUM_SPEICHERN, "");
            this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(new String[]{this.orgPfad}));
        });
    }

    private void waitForFileSizeFutures() {
        try {
            this.hqFuture.get();
            this.hochFuture.get();
            this.kleinFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Error occured while waiting for file size futures", (Throwable)e);
        }
        finally {
            ApplicationConfiguration.getConfiguration().setProperty("download.fetch_file_size", (Object)this.restoreFetchSize);
        }
    }

    private void setupPfadSpeichernCheckBox() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        this.jCheckBoxPfadSpeichern.setSelected(config.getBoolean("download.path.last_used.show", true));
        this.jCheckBoxPfadSpeichern.addActionListener(e -> config.setProperty("download.path.last_used.show", (Object)this.jCheckBoxPfadSpeichern.isSelected()));
    }

    private void setNameFilm() {
        if (!this.nameGeaendert) {
            this.stopBeob = true;
            this.datenDownload = new DatenDownload(this.active_pSet, this.film, 2, null, "", "", this.getFilmResolution().toString());
            if (this.datenDownload.arr[29].isEmpty()) {
                this.jTextFieldName.setEnabled(false);
                this.jComboBoxPfad.setEnabled(false);
                this.jButtonZiel.setEnabled(false);
                this.jTextFieldName.setText("");
                this.jComboBoxPfad.setModel(new DefaultComboBoxModel<String>(new String[]{""}));
            } else {
                this.jTextFieldName.setEnabled(true);
                this.jComboBoxPfad.setEnabled(true);
                this.jButtonZiel.setEnabled(true);
                this.jTextFieldName.setText(this.datenDownload.arr[29]);
                DialogAddDownload.setModelPfad(this.datenDownload.arr[30], this.jComboBoxPfad);
                this.orgPfad = this.datenDownload.arr[30];
            }
            this.stopBeob = false;
        }
    }

    private long getFreeDiskSpace(String strPath) {
        long usableSpace = 0L;
        if (!strPath.isEmpty()) {
            try {
                Path path;
                if (Files.notExists(path, new LinkOption[0])) {
                    for (path = Paths.get(strPath, new String[0]); Files.notExists(path, new LinkOption[0]) && path != null; path = path.getParent()) {
                    }
                }
                if (path == null) {
                    usableSpace = 0L;
                } else {
                    FileStore fileStore = Files.getFileStore(path);
                    usableSpace = fileStore.getUsableSpace();
                }
            }
            catch (Exception ex) {
                logger.error("getFreeDiskSpace Failed", (Throwable)ex);
            }
        }
        return usableSpace;
    }

    private void calculateAndCheckDiskSpace() {
        Color fgColor = UIManager.getColor(KEY_LABEL_FOREGROUND);
        if (fgColor != null) {
            this.jRadioButtonAufloesungHd.setForeground(fgColor);
            this.jRadioButtonAufloesungHoch.setForeground(fgColor);
            this.jRadioButtonAufloesungKlein.setForeground(fgColor);
        }
        try {
            TitledBorder filmBorder = (TitledBorder)this.jPanelSize.getBorder();
            long usableSpace = this.getFreeDiskSpace(this.cbPathTextComponent.getText());
            if (usableSpace > 0L) {
                filmBorder.setTitle("Download-Qualit\u00e4t [ Freier Speicherplatz: " + FileUtils.humanReadableByteCountBinary(usableSpace) + " ]");
            } else {
                filmBorder.setTitle(TITLED_BORDER_STRING);
            }
            this.jPanelSize.repaint();
            if ((usableSpace /= 1000000L) > 0L) {
                int size;
                if (!this.dateiGroesse_HQ.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_HQ)) > usableSpace) {
                    this.jRadioButtonAufloesungHd.setForeground(Color.red);
                }
                if (!this.dateiGroesse_Hoch.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_Hoch)) > usableSpace) {
                    this.jRadioButtonAufloesungHoch.setForeground(Color.red);
                }
                if (!this.dateiGroesse_Klein.isEmpty() && (long)(size = Integer.parseInt(this.dateiGroesse_Klein)) > usableSpace) {
                    this.jRadioButtonAufloesungKlein.setForeground(Color.red);
                }
            }
        }
        catch (Exception ex) {
            logger.error("calculateAndCheckDiskSpace()", (Throwable)ex);
        }
    }

    private boolean isHighQualityRequested() {
        return this.active_pSet.arr[15].equals(FilmResolution.Enum.HIGH_QUALITY.toString()) && this.film.isHighQuality();
    }

    private boolean isLowQualityRequested() {
        return this.active_pSet.arr[15].equals(FilmResolution.Enum.LOW.toString()) && !this.film.getLowQualityUrl().isEmpty();
    }

    private void setupResolutionButtons() {
        this.active_pSet = (DatenPset)this.listeSpeichern.get(this.jComboBoxPset.getSelectedIndex());
        this.prepareResolutionButtons();
        this.prepareSubtitleCheckbox();
        this.setNameFilm();
    }

    private void setupInfoFileCreationCheckBox() {
        boolean isLivestream = this.film.isLivestream();
        this.jCheckBoxInfodatei.setEnabled(!isLivestream);
        if (!isLivestream) {
            this.jCheckBoxInfodatei.setSelected(this.active_pSet.shouldCreateInfofile());
        } else {
            this.jCheckBoxInfodatei.setSelected(false);
        }
    }

    private void prepareResolutionButtons() {
        this.requestedResolution.ifPresent(it -> {
            this.highQualityMandated = it == FilmResolution.Enum.HIGH_QUALITY;
        });
        if (this.highQualityMandated || this.isHighQualityRequested()) {
            this.jRadioButtonAufloesungHd.setSelected(true);
        } else if (this.isLowQualityRequested()) {
            this.jRadioButtonAufloesungKlein.setSelected(true);
        } else {
            this.jRadioButtonAufloesungHoch.setSelected(true);
        }
    }

    private void prepareSubtitleCheckbox() {
        if (!this.film.hasSubtitle()) {
            this.jCheckBoxSubtitle.setEnabled(false);
        } else {
            this.jCheckBoxSubtitle.setSelected(this.active_pSet.shouldDownloadSubtitle());
        }
    }

    private FilmResolution.Enum getFilmResolution() {
        if (this.jRadioButtonAufloesungHd.isSelected()) {
            return FilmResolution.Enum.HIGH_QUALITY;
        }
        if (this.jRadioButtonAufloesungKlein.isSelected()) {
            return FilmResolution.Enum.LOW;
        }
        return FilmResolution.Enum.NORMAL;
    }

    private String getFilmSize() {
        if (this.jRadioButtonAufloesungHd.isSelected()) {
            return this.dateiGroesse_HQ;
        }
        if (this.jRadioButtonAufloesungKlein.isSelected()) {
            return this.dateiGroesse_Klein;
        }
        return this.dateiGroesse_Hoch;
    }

    private boolean check() {
        boolean ok = false;
        Object pfad = Objects.requireNonNull(this.jComboBoxPfad.getSelectedItem()).toString();
        String name = this.jTextFieldName.getText();
        if (this.datenDownload != null) {
            if (((String)pfad).isEmpty() || name.isEmpty()) {
                MVMessageDialog.showMessageDialog(this, "Pfad oder Name ist leer", "Fehlerhafter Pfad/Name!", 0);
            } else {
                if (!((String)pfad).substring(((String)pfad).length() - 1).equals(File.separator)) {
                    pfad = (String)pfad + File.separator;
                }
                if (GuiFunktionenProgramme.checkPathWriteable((String)pfad)) {
                    ok = true;
                } else {
                    MVMessageDialog.showMessageDialog(this, "Pfad ist nicht beschreibbar", "Fehlerhafter Pfad!", 0);
                }
            }
        }
        return ok;
    }

    private void addDownloadToQueue() {
        Daten.getInstance().getListeDownloads().addMitNummer(this.datenDownload);
        MessageBus.getMessageBus().publishAsync((Object)new DownloadListChangedEvent());
        if (this.jCheckBoxStarten.isSelected()) {
            this.datenDownload.startDownload();
        }
    }

    private void saveDownload() {
        this.datenDownload = new DatenDownload(this.active_pSet, this.film, 2, null, this.jTextFieldName.getText(), Objects.requireNonNull(this.jComboBoxPfad.getSelectedItem()).toString(), this.getFilmResolution().toString());
        this.datenDownload.setGroesse(this.getFilmSize());
        this.datenDownload.arr[35] = Boolean.toString(this.jCheckBoxInfodatei.isSelected());
        this.datenDownload.arr[37] = Boolean.toString(this.jCheckBoxSubtitle.isSelected());
        this.addDownloadToQueue();
        this.dispose();
    }

    private void initComponents() {
        ButtonGroup buttonGroup1 = new ButtonGroup();
        this.jButtonOk = new JButton();
        this.jButtonAbbrechen = new JButton();
        this.jCheckBoxStarten = new JCheckBox();
        JPanel jPanel1 = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.jCheckBoxInfodatei = new JCheckBox();
        this.jCheckBoxPfadSpeichern = new JCheckBox();
        this.jCheckBoxSubtitle = new JCheckBox();
        JPanel jPanel7 = new JPanel();
        JLabel jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        JLabel jLabelSet = new JLabel();
        this.jComboBoxPset = new JComboBox();
        JLabel jLabel4 = new JLabel();
        JPanel jPanel4 = new JPanel();
        this.jComboBoxPfad = new JComboBox();
        Box.Filler filler1 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.jButtonZiel = new JButton();
        Box.Filler filler2 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.jButtonDelHistory = new JButton();
        this.jPanelSize = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.btnRequestLiveInfo = new JButton();
        this.lblBusyIndicator = new JXBusyLabel();
        JPanel jPanel5 = new JPanel();
        this.lblStatus = new JLabel();
        this.lblAudioInfo = new JLabel();
        JPanel jPanel6 = new JPanel();
        this.jRadioButtonAufloesungHd = new JRadioButton();
        this.jRadioButtonAufloesungHoch = new JRadioButton();
        this.jRadioButtonAufloesungKlein = new JRadioButton();
        this.jTextFieldSender = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Film speichern");
        this.setMinimumSize(new Dimension(646, 372));
        this.jButtonOk.setText("Ok");
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jCheckBoxStarten.setSelected(true);
        this.jCheckBoxStarten.setText("Download sofort starten");
        jPanel2.setLayout(new GridLayout(2, 2));
        this.jCheckBoxInfodatei.setText("Lege Infodatei an");
        this.jCheckBoxInfodatei.setToolTipText("Erzeugt eine Infodatei im Format \"Infodatei.txt\"");
        jPanel2.add(this.jCheckBoxInfodatei);
        this.jCheckBoxPfadSpeichern.setText("Zielpfad speichern");
        jPanel2.add(this.jCheckBoxPfadSpeichern);
        this.jCheckBoxSubtitle.setText("Untertitel speichern: \"Filmname.xxx\"");
        jPanel2.add(this.jCheckBoxSubtitle);
        jPanel7.setMaximumSize(new Dimension(606, Short.MAX_VALUE));
        jLabel1.setText("Zielpfad:");
        jLabelSet.setText("Set:");
        jLabel4.setText("Dateiname:");
        jPanel4.setLayout(new BoxLayout(jPanel4, 2));
        this.jComboBoxPfad.setEditable(true);
        jPanel4.add(this.jComboBoxPfad);
        jPanel4.add(filler1);
        this.jButtonZiel.setText("F");
        this.jButtonZiel.setToolTipText("Zielpfad ausw\u00e4hlen");
        jPanel4.add(this.jButtonZiel);
        jPanel4.add(filler2);
        this.jButtonDelHistory.setText("H");
        this.jButtonDelHistory.setToolTipText("History l\u00f6schen");
        jPanel4.add(this.jButtonDelHistory);
        GroupLayout jPanel7Layout = new GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabelSet).addComponent(jLabel1)).addGap(20, 20, 20).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel4, -1, -1, Short.MAX_VALUE).addComponent(this.jComboBoxPset, 0, -1, Short.MAX_VALUE))).addGroup(jPanel7Layout.createSequentialGroup().addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldName))).addContainerGap()));
        jPanel7Layout.setVerticalGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel7Layout.createSequentialGroup().addContainerGap().addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabelSet).addComponent(this.jComboBoxPset, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel4, -2, -1, -2).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel7Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel4).addComponent(this.jTextFieldName, -2, -1, -2)).addContainerGap()));
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel2, -1, 606, Short.MAX_VALUE).addComponent(jPanel7, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jPanel7, -2, -1, -2).addGap(12, 12, 12).addComponent(jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelSize.setBorder(BorderFactory.createTitledBorder(TITLED_BORDER_STRING));
        jPanel3.setLayout(new FlowLayout(0));
        this.btnRequestLiveInfo.setText("Codec-Details abrufen...");
        jPanel3.add(this.btnRequestLiveInfo);
        jPanel3.add((Component)this.lblBusyIndicator);
        jPanel5.setLayout(new GridLayout(2, 1));
        this.lblStatus.setText("status");
        jPanel5.add(this.lblStatus);
        this.lblAudioInfo.setText("audio");
        jPanel5.add(this.lblAudioInfo);
        jPanel3.add(jPanel5);
        buttonGroup1.add(this.jRadioButtonAufloesungHd);
        this.jRadioButtonAufloesungHd.setText("H\u00f6chste/Hoch");
        jPanel6.add(this.jRadioButtonAufloesungHd);
        buttonGroup1.add(this.jRadioButtonAufloesungHoch);
        this.jRadioButtonAufloesungHoch.setText("Mittel");
        jPanel6.add(this.jRadioButtonAufloesungHoch);
        buttonGroup1.add(this.jRadioButtonAufloesungKlein);
        this.jRadioButtonAufloesungKlein.setText("Niedrig");
        jPanel6.add(this.jRadioButtonAufloesungKlein);
        GroupLayout jPanelSizeLayout = new GroupLayout(this.jPanelSize);
        this.jPanelSize.setLayout(jPanelSizeLayout);
        jPanelSizeLayout.setHorizontalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel3, -1, 596, Short.MAX_VALUE).addGroup(jPanelSizeLayout.createSequentialGroup().addComponent(jPanel6, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanelSizeLayout.setVerticalGroup(jPanelSizeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSizeLayout.createSequentialGroup().addContainerGap().addComponent(jPanel6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTextFieldSender.setEditable(false);
        this.jTextFieldSender.setFont(this.jTextFieldSender.getFont().deriveFont(this.jTextFieldSender.getFont().getStyle() | 1));
        this.jTextFieldSender.setText(" ARD: Tatort, ...");
        this.jTextFieldSender.setBorder(BorderFactory.createTitledBorder("Film"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jTextFieldSender, GroupLayout.Alignment.LEADING).addComponent(this.jPanelSize, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jCheckBoxStarten).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 264, Short.MAX_VALUE).addComponent(this.jButtonOk, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldSender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelSize, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxStarten, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonAbbrechen))).addContainerGap()));
        this.pack();
    }

    private static class DialogPositionComponentListener
    extends ComponentAdapter {
        private DialogPositionComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.storeWindowPosition(e);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.storeWindowPosition(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void storeWindowPosition(ComponentEvent e) {
            Configuration config = ApplicationConfiguration.getConfiguration();
            Component component = e.getComponent();
            Dimension dims = component.getSize();
            Point loc = component.getLocation();
            try {
                config.lock(LockMode.WRITE);
                config.setProperty("application.ui.adddownload_dialog.width", (Object)dims.width);
                config.setProperty("application.ui.adddownload_dialog.height", (Object)dims.height);
                config.setProperty("application.ui.adddownload_dialog.location.x", (Object)loc.x);
                config.setProperty("application.ui.adddownload_dialog.location.y", (Object)loc.y);
            }
            finally {
                config.unlock(LockMode.WRITE);
            }
        }
    }
}

