/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser;

import java.util.HashMap;
import org.jspecify.annotations.Nullable;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.Normalizer;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attributes;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Range;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.CharacterReader;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseSettings;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.TreeBuilder;

abstract class Token {
    final TokenType type;
    private int startPos;
    private int endPos = -1;

    /*
     * WARNING - void declaration
     */
    private Token(TokenType type) {
        void var1_1;
        this.type = var1_1;
    }

    String tokenType() {
        return this.getClass().getSimpleName();
    }

    Token reset() {
        this.startPos = -1;
        this.endPos = -1;
        return this;
    }

    int startPos() {
        return this.startPos;
    }

    /*
     * WARNING - void declaration
     */
    void startPos(int pos) {
        void var1_1;
        this.startPos = var1_1;
    }

    int endPos() {
        return this.endPos;
    }

    /*
     * WARNING - void declaration
     */
    void endPos(int pos) {
        void var1_1;
        this.endPos = var1_1;
    }

    static void reset(StringBuilder sb) {
        if (sb != null) {
            StringBuilder stringBuilder;
            sb.delete(0, stringBuilder.length());
        }
    }

    final boolean isDoctype() {
        return this.type == TokenType.Doctype;
    }

    final Doctype asDoctype() {
        return (Doctype)this;
    }

    final boolean isStartTag() {
        return this.type == TokenType.StartTag;
    }

    final StartTag asStartTag() {
        return (StartTag)this;
    }

    final boolean isEndTag() {
        return this.type == TokenType.EndTag;
    }

    final EndTag asEndTag() {
        return (EndTag)this;
    }

    final boolean isComment() {
        return this.type == TokenType.Comment;
    }

    final Comment asComment() {
        return (Comment)this;
    }

    final boolean isCharacter() {
        return this.type == TokenType.Character;
    }

    final boolean isCData() {
        return this instanceof CData;
    }

    final Character asCharacter() {
        return (Character)this;
    }

    final boolean isEOF() {
        return this.type == TokenType.EOF;
    }

    public static final class TokenType
    extends Enum<TokenType> {
        public static final /* enum */ TokenType Doctype = new TokenType();
        public static final /* enum */ TokenType StartTag = new TokenType();
        public static final /* enum */ TokenType EndTag = new TokenType();
        public static final /* enum */ TokenType Comment = new TokenType();
        public static final /* enum */ TokenType Character = new TokenType();
        public static final /* enum */ TokenType EOF = new TokenType();
        private static final /* synthetic */ TokenType[] $VALUES;

        public static TokenType[] values() {
            return (TokenType[])$VALUES.clone();
        }

        private static /* synthetic */ TokenType[] $values() {
            return new TokenType[]{Doctype, StartTag, EndTag, Comment, Character, EOF};
        }

        static {
            $VALUES = TokenType.$values();
        }
    }

    static final class Doctype
    extends Token {
        final StringBuilder name = new StringBuilder();
        String pubSysKey = null;
        final StringBuilder publicIdentifier = new StringBuilder();
        final StringBuilder systemIdentifier = new StringBuilder();
        boolean forceQuirks = false;

        Doctype() {
            super(TokenType.Doctype);
        }

        @Override
        final Token reset() {
            super.reset();
            Doctype.reset(this.name);
            this.pubSysKey = null;
            Doctype.reset(this.publicIdentifier);
            Doctype.reset(this.systemIdentifier);
            this.forceQuirks = false;
            return this;
        }

        final String getName() {
            return this.name.toString();
        }

        final String getPubSysKey() {
            return this.pubSysKey;
        }

        final String getPublicIdentifier() {
            return this.publicIdentifier.toString();
        }

        public final String getSystemIdentifier() {
            return this.systemIdentifier.toString();
        }

        public final boolean isForceQuirks() {
            return this.forceQuirks;
        }

        public final String toString() {
            return "<!doctype " + this.getName() + ">";
        }
    }

    static final class StartTag
    extends Tag {
        /*
         * WARNING - void declaration
         */
        StartTag(TreeBuilder treeBuilder) {
            super(TokenType.StartTag, (TreeBuilder)var1_1);
            void var1_1;
        }

        @Override
        final Tag reset() {
            super.reset();
            this.attributes = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final StartTag nameAttr(String name, Attributes attributes) {
            void var2_2;
            void var1_1;
            this.tagName = var1_1;
            this.attributes = var2_2;
            this.normalName = ParseSettings.normalName(this.tagName);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            String closer;
            String string = closer = this.isSelfClosing() ? "/>" : ">";
            if (this.hasAttributes() && this.attributes.size() > 0) {
                return "<" + this.toStringName() + " " + this.attributes.toString() + closer;
            }
            return "<" + this.toStringName() + (String)var1_1;
        }
    }

    static final class EndTag
    extends Tag {
        /*
         * WARNING - void declaration
         */
        EndTag(TreeBuilder treeBuilder) {
            super(TokenType.EndTag, (TreeBuilder)var1_1);
            void var1_1;
        }

        public final String toString() {
            return "</" + this.toStringName() + ">";
        }
    }

    static final class Comment
    extends Token {
        private final StringBuilder data = new StringBuilder();
        private String dataS;
        boolean bogus = false;

        @Override
        final Token reset() {
            super.reset();
            Comment.reset(this.data);
            this.dataS = null;
            this.bogus = false;
            return this;
        }

        Comment() {
            super(TokenType.Comment);
        }

        final String getData() {
            if (this.dataS != null) {
                return this.dataS;
            }
            return this.data.toString();
        }

        /*
         * WARNING - void declaration
         */
        final Comment append(String append) {
            this.ensureData();
            if (this.data.length() == 0) {
                this.dataS = append;
            } else {
                void var1_1;
                this.data.append((String)var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final Comment append(char append) {
            void var1_1;
            this.ensureData();
            this.data.append((char)var1_1);
            return this;
        }

        private void ensureData() {
            if (this.dataS != null) {
                this.data.append(this.dataS);
                this.dataS = null;
            }
        }

        public final String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    static final class CData
    extends Character {
        /*
         * WARNING - void declaration
         */
        CData(String data) {
            void var1_1;
            this.data((String)var1_1);
        }

        @Override
        public final String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    static class Character
    extends Token
    implements Cloneable {
        private String data;

        Character() {
            super(TokenType.Character);
        }

        @Override
        Token reset() {
            super.reset();
            this.data = null;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Character data(String data) {
            void var1_1;
            this.data = var1_1;
            return this;
        }

        String getData() {
            return this.data;
        }

        public String toString() {
            return this.getData();
        }

        /*
         * WARNING - void declaration
         */
        protected Character clone() {
            try {
                return (Character)super.clone();
            }
            catch (CloneNotSupportedException e) {
                void var1_1;
                throw new RuntimeException((Throwable)var1_1);
            }
        }
    }

    static final class EOF
    extends Token {
        EOF() {
            super(TokenType.EOF);
        }

        @Override
        final Token reset() {
            super.reset();
            return this;
        }

        public final String toString() {
            return "";
        }
    }

    static abstract class Tag
    extends Token {
        protected @Nullable String tagName;
        protected @Nullable String normalName;
        boolean selfClosing = false;
        @Nullable Attributes attributes;
        private @Nullable String attrName;
        private final StringBuilder attrNameSb = new StringBuilder();
        private boolean hasAttrName = false;
        private @Nullable String attrValue;
        private final StringBuilder attrValueSb = new StringBuilder();
        private boolean hasAttrValue = false;
        private boolean hasEmptyAttrValue = false;
        final TreeBuilder treeBuilder;
        final boolean trackSource;
        int attrNameStart;
        int attrNameEnd;
        int attrValStart;
        int attrValEnd;

        /*
         * WARNING - void declaration
         */
        Tag(TokenType type, TreeBuilder treeBuilder) {
            super((TokenType)var1_1);
            void var2_2;
            void var1_1;
            this.treeBuilder = treeBuilder;
            this.trackSource = var2_2.trackSourceRange;
        }

        @Override
        Tag reset() {
            super.reset();
            this.tagName = null;
            this.normalName = null;
            this.selfClosing = false;
            this.attributes = null;
            this.resetPendingAttr();
            return this;
        }

        private void resetPendingAttr() {
            Tag.reset(this.attrNameSb);
            this.attrName = null;
            this.hasAttrName = false;
            Tag.reset(this.attrValueSb);
            this.attrValue = null;
            this.hasEmptyAttrValue = false;
            this.hasAttrValue = false;
            if (this.trackSource) {
                Tag tag = this;
                Tag tag2 = this;
                tag2.attrValEnd = -1;
                tag2.attrValStart = -1;
                tag.attrNameEnd = -1;
                tag.attrNameStart = -1;
            }
        }

        /*
         * WARNING - void declaration
         */
        final void newAttribute() {
            String string;
            String name;
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            if (this.hasAttrName && this.attributes.size() < 512 && (name = (string = this.attrNameSb.length() > 0 ? this.attrNameSb.toString() : this.attrName).trim()).length() > 0) {
                void var2_2;
                String value = this.hasAttrValue ? (this.attrValueSb.length() > 0 ? this.attrValueSb.toString() : this.attrValue) : (this.hasEmptyAttrValue ? "" : null);
                this.attributes.add(name, (String)var2_2);
                this.trackAttributeRange(string);
            }
            this.resetPendingAttr();
        }

        /*
         * WARNING - void declaration
         */
        private void trackAttributeRange(String name) {
            if (this.trackSource && this.isStartTag()) {
                void var2_4;
                void var1_1;
                void var3_5;
                StartTag start = this.asStartTag();
                CharacterReader r = start.treeBuilder.reader;
                boolean preserve = start.treeBuilder.settings.preserveAttributeCase();
                assert (this.attributes != null);
                HashMap<void, void> attrRanges = (HashMap<void, void>)this.attributes.userData("jsoup.attrs");
                if (attrRanges == null) {
                    attrRanges = new HashMap<void, void>();
                    this.attributes.userData("jsoup.attrs", attrRanges);
                }
                if (!preserve) {
                    name = Normalizer.lowerCase(name);
                }
                if (attrRanges.containsKey(name)) {
                    return;
                }
                if (!this.hasAttrValue) {
                    Tag tag = this;
                    tag.attrValStart = tag.attrValEnd = this.attrNameEnd;
                }
                Range.AttributeRange range = new Range.AttributeRange(new Range(new Range.Position(this.attrNameStart, r.lineNumber(this.attrNameStart), r.columnNumber(this.attrNameStart)), new Range.Position(this.attrNameEnd, r.lineNumber(this.attrNameEnd), r.columnNumber(this.attrNameEnd))), new Range(new Range.Position(this.attrValStart, r.lineNumber(this.attrValStart), r.columnNumber(this.attrValStart)), new Range.Position(this.attrValEnd, r.lineNumber(this.attrValEnd), var3_5.columnNumber(this.attrValEnd))));
                attrRanges.put(var1_1, var2_4);
            }
        }

        final boolean hasAttributes() {
            return this.attributes != null;
        }

        /*
         * WARNING - void declaration
         */
        final boolean hasAttribute(String key) {
            void var1_1;
            return this.attributes != null && this.attributes.hasKey((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final boolean hasAttributeIgnoreCase(String key) {
            void var1_1;
            return this.attributes != null && this.attributes.hasKeyIgnoreCase((String)var1_1);
        }

        final void finaliseTag() {
            if (this.hasAttrName) {
                this.newAttribute();
            }
        }

        final String name() {
            Validate.isFalse(this.tagName == null || this.tagName.length() == 0);
            return this.tagName;
        }

        final String normalName() {
            return this.normalName;
        }

        final String toStringName() {
            if (this.tagName != null) {
                return this.tagName;
            }
            return "[unset]";
        }

        /*
         * WARNING - void declaration
         */
        final Tag name(String name) {
            void var1_1;
            this.tagName = var1_1;
            this.normalName = ParseSettings.normalName(this.tagName);
            return this;
        }

        final boolean isSelfClosing() {
            return this.selfClosing;
        }

        /*
         * WARNING - void declaration
         */
        final void appendTagName(String append) {
            void var1_1;
            append = append.replace('\u0000', '\ufffd');
            this.tagName = this.tagName == null ? append : this.tagName.concat((String)var1_1);
            this.normalName = ParseSettings.normalName(this.tagName);
        }

        /*
         * WARNING - void declaration
         */
        final void appendTagName(char append) {
            void var1_1;
            this.appendTagName(String.valueOf((char)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeName(String append, int startPos, int endPos) {
            void var1_1;
            void var3_3;
            void var2_2;
            append = append.replace('\u0000', '\ufffd');
            this.ensureAttrName((int)var2_2, (int)var3_3);
            if (this.attrNameSb.length() == 0) {
                this.attrName = append;
                return;
            }
            this.attrNameSb.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeName(char append, int startPos, int endPos) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.ensureAttrName((int)var2_2, (int)var3_3);
            this.attrNameSb.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(String append, int startPos, int endPos) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.ensureAttrValue((int)var2_2, (int)var3_3);
            if (this.attrValueSb.length() == 0) {
                this.attrValue = append;
                return;
            }
            this.attrValueSb.append((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(char append, int startPos, int endPos) {
            void var1_1;
            void var3_3;
            void var2_2;
            this.ensureAttrValue((int)var2_2, (int)var3_3);
            this.attrValueSb.append((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void appendAttributeValue(int[] appendCodepoints, int startPos, int endPos) {
            void var1_1;
            int n;
            int n2;
            this.ensureAttrValue(n2, n);
            for (void codepoint : var1_1) {
                this.attrValueSb.appendCodePoint((int)codepoint);
            }
        }

        final void setEmptyAttributeValue() {
            this.hasEmptyAttrValue = true;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureAttrName(int startPos, int endPos) {
            this.hasAttrName = true;
            if (this.attrName != null) {
                this.attrNameSb.append(this.attrName);
                this.attrName = null;
            }
            if (this.trackSource) {
                void var2_2;
                void var1_1;
                this.attrNameStart = this.attrNameStart >= 0 ? this.attrNameStart : var1_1;
                this.attrNameEnd = var2_2;
            }
        }

        /*
         * WARNING - void declaration
         */
        private void ensureAttrValue(int startPos, int endPos) {
            this.hasAttrValue = true;
            if (this.attrValue != null) {
                this.attrValueSb.append(this.attrValue);
                this.attrValue = null;
            }
            if (this.trackSource) {
                void var2_2;
                void var1_1;
                this.attrValStart = this.attrValStart >= 0 ? this.attrValStart : var1_1;
                this.attrValEnd = var2_2;
            }
        }
    }
}

