/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.ContentStreamHandlerBase;
import org.apache.solr.handler.loader.CSVLoader;
import org.apache.solr.handler.loader.CborLoader;
import org.apache.solr.handler.loader.ContentStreamLoader;
import org.apache.solr.handler.loader.JavabinLoader;
import org.apache.solr.handler.loader.JsonLoader;
import org.apache.solr.handler.loader.XMLLoader;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.processor.UpdateRequestProcessor;

public class UpdateRequestHandler
extends ContentStreamHandlerBase
implements PermissionNameProvider {
    public static final String ADD = "add";
    public static final String DELETE = "delete";
    public static final String OPTIMIZE = "optimize";
    public static final String COMMIT = "commit";
    public static final String ROLLBACK = "rollback";
    public static final String WAIT_SEARCHER = "waitSearcher";
    public static final String SOFT_COMMIT = "softCommit";
    public static final String OVERWRITE = "overwrite";
    public static final String VERSION = "version";
    public static final String COMMIT_WITHIN = "commitWithin";
    protected Map<String, ContentStreamLoader> loaders = null;
    ContentStreamLoader instance = new ContentStreamLoader(){

        @Override
        public void load(SolrQueryRequest req, SolrQueryResponse rsp, ContentStream stream, UpdateRequestProcessor processor) throws Exception {
            ContentStreamLoader loader = UpdateRequestHandler.this.pathVsLoaders.get(req.getContext().get("path"));
            if (loader == null) {
                String type = req.getParams().get("update.contentType");
                if (type == null) {
                    type = stream.getContentType();
                }
                if (type == null) {
                    throw new SolrException(SolrException.ErrorCode.UNSUPPORTED_MEDIA_TYPE, "Missing ContentType");
                }
                int idx = type.indexOf(59);
                if (idx > 0) {
                    type = type.substring(0, idx);
                }
                if ((loader = UpdateRequestHandler.this.loaders.get(type)) == null) {
                    throw new SolrException(SolrException.ErrorCode.UNSUPPORTED_MEDIA_TYPE, "Unsupported ContentType: " + type + "  Not in: " + String.valueOf(UpdateRequestHandler.this.loaders.keySet()));
                }
            }
            if (loader.getDefaultWT() != null) {
                this.setDefaultWT(req, loader);
            }
            loader.load(req, rsp, stream, processor);
        }

        private void setDefaultWT(SolrQueryRequest req, ContentStreamLoader loader) {
            SolrParams params = req.getParams();
            if (params.get("wt") == null) {
                String wt = loader.getDefaultWT();
                if (req.getCore().getQueryResponseWriter(wt) != null) {
                    Map<String, String> map = Map.of("wt", wt);
                    req.setParams(SolrParams.wrapDefaults((SolrParams)params, (SolrParams)new MapSolrParams(map)));
                }
            }
        }
    };
    private Map<String, ContentStreamLoader> pathVsLoaders = new HashMap<String, ContentStreamLoader>();
    public static final String DOC_PATH = "/update/json/docs";
    public static final String JSON_PATH = "/update/json";
    public static final String CSV_PATH = "/update/csv";
    public static final String BIN_PATH = "/update/bin";
    public static final String CBOR_PATH = "/update/cbor";

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        this.loaders = Collections.unmodifiableMap(this.createDefaultLoaders(args));
    }

    protected void setAssumeContentType(String ct) {
        if (this.invariants == null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("update.contentType", ct);
            this.invariants = new MapSolrParams(map);
        } else {
            ModifiableSolrParams params = new ModifiableSolrParams(this.invariants);
            params.set("update.contentType", new String[]{ct});
            this.invariants = params;
        }
    }

    protected Map<String, ContentStreamLoader> createDefaultLoaders(NamedList<?> args) {
        SolrParams p = null;
        if (args != null) {
            p = args.toSolrParams();
        }
        HashMap<String, ContentStreamLoader> registry = new HashMap<String, ContentStreamLoader>();
        registry.put("application/xml", new XMLLoader().init(p));
        registry.put("application/json", new JsonLoader().init(p));
        registry.put("application/csv", new CSVLoader().init(p));
        registry.put("application/javabin", new JavabinLoader(this.instance).init(p));
        registry.put("application/cbor", CborLoader.createLoader(p));
        registry.put("text/csv", (ContentStreamLoader)registry.get("application/csv"));
        registry.put("text/xml", (ContentStreamLoader)registry.get("application/xml"));
        registry.put("text/json", (ContentStreamLoader)registry.get("application/json"));
        this.pathVsLoaders.put(JSON_PATH, (ContentStreamLoader)registry.get("application/json"));
        this.pathVsLoaders.put(DOC_PATH, (ContentStreamLoader)registry.get("application/json"));
        this.pathVsLoaders.put(CSV_PATH, (ContentStreamLoader)registry.get("application/csv"));
        this.pathVsLoaders.put(BIN_PATH, (ContentStreamLoader)registry.get("application/javabin"));
        this.pathVsLoaders.put(CBOR_PATH, (ContentStreamLoader)registry.get("application/cbor"));
        return registry;
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext ctx) {
        return PermissionNameProvider.Name.UPDATE_PERM;
    }

    @Override
    protected ContentStreamLoader newLoader(SolrQueryRequest req, UpdateRequestProcessor processor) {
        return this.instance;
    }

    @Override
    public String getDescription() {
        return "Add documents using XML, CSV, JSON, or javabin.";
    }

    @Override
    public SolrInfoBean.Category getCategory() {
        return SolrInfoBean.Category.UPDATE;
    }
}

