#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 darcs
version:              2.16.4
visibility:           public
id:                   darcs-2.16.4-3xL19QV72jG2Nz62qck8cR
key:                  darcs-2.16.4-3xL19QV72jG2Nz62qck8cR
license:              GPL-2.0-or-later
maintainer:           <darcs-devel@darcs.net>
author:               David Roundy <droundy@darcs.net>, <darcs-devel@darcs.net>
stability:            Experimental
homepage:             http://darcs.net/
synopsis:             a distributed, interactive, smart revision control system
description:
    Darcs is a free, open source revision control
    system. It is:

    * Distributed: Darcs was one of the first revision control
    systems in which every user has access to the full command
    set, removing boundaries between server and client or
    committer and non-committers.

    * Interactive: Darcs is easy to learn and efficient to use
    because it asks you questions in response to simple
    commands, giving you choices in your work flow. You can
    choose to record one change in a file, while ignoring
    another. As you update from upstream, you can review each
    patch, picking and choosing which patches are appropriate.

    * Smart: Darcs is different from most revision control
    systems in that it is based on the notion of change (or
    patch), rather than version. An underlying algebra of
    patches determines whether changes can be re-ordered. The
    laws of this algebra guarantee that the result of merging
    depends only on the final set of patches applied in a
    repository and not on their order.

    * Simple: As a consequence, Darcs offers a conceptually
    simpler view of the state of a repository: it is given by
    the set of patches it contains. Pulling and pushing
    patches merely transfers them from one set to another. So
    called "cherry-picking" is the default mode of operation,
    and it fully preserves the identity of patches.

category:             Development
abi:                  09be0aa64e2e30e1cb6d4d06b618f466
exposed:              True
exposed-modules:
    Darcs.Patch Darcs.Patch.Annotate Darcs.Patch.Apply
    Darcs.Patch.ApplyMonad Darcs.Patch.Bracketed Darcs.Patch.Bundle
    Darcs.Patch.Choices Darcs.Patch.Commute Darcs.Patch.CommuteFn
    Darcs.Patch.CommuteNoConflicts Darcs.Patch.Conflict
    Darcs.Patch.Debug Darcs.Patch.Depends Darcs.Patch.Effect
    Darcs.Patch.FileHunk Darcs.Patch.Format Darcs.Patch.FromPrim
    Darcs.Patch.Ident Darcs.Patch.Index.Monad Darcs.Patch.Index.Types
    Darcs.Patch.Info Darcs.Patch.Inspect Darcs.Patch.Invert
    Darcs.Patch.Invertible Darcs.Patch.Match Darcs.Patch.Merge
    Darcs.Patch.MonadProgress Darcs.Patch.Named
    Darcs.Patch.Named.Wrapped Darcs.Patch.PatchInfoAnd
    Darcs.Patch.Permutations Darcs.Patch.Prim Darcs.Patch.Prim.Class
    Darcs.Patch.Prim.FileUUID Darcs.Patch.Prim.FileUUID.Apply
    Darcs.Patch.Prim.FileUUID.Coalesce
    Darcs.Patch.Prim.FileUUID.Commute Darcs.Patch.Prim.FileUUID.Core
    Darcs.Patch.Prim.FileUUID.Details
    Darcs.Patch.Prim.FileUUID.ObjectMap Darcs.Patch.Prim.FileUUID.Read
    Darcs.Patch.Prim.FileUUID.Show Darcs.Patch.Prim.Named
    Darcs.Patch.Prim.V1 Darcs.Patch.Prim.V1.Apply
    Darcs.Patch.Prim.V1.Coalesce Darcs.Patch.Prim.V1.Commute
    Darcs.Patch.Prim.V1.Core Darcs.Patch.Prim.V1.Details
    Darcs.Patch.Prim.V1.Mangle Darcs.Patch.Prim.V1.Read
    Darcs.Patch.Prim.V1.Show Darcs.Patch.Prim.WithName
    Darcs.Patch.Progress Darcs.Patch.Read Darcs.Patch.Rebase.Change
    Darcs.Patch.Rebase.Fixup Darcs.Patch.Rebase.Legacy.Item
    Darcs.Patch.Rebase.Name Darcs.Patch.Rebase.PushFixup
    Darcs.Patch.Rebase.Suspended Darcs.Patch.RegChars
    Darcs.Patch.Repair Darcs.Patch.RepoPatch Darcs.Patch.RepoType
    Darcs.Patch.Set Darcs.Patch.Show Darcs.Patch.Split
    Darcs.Patch.Summary Darcs.Patch.SummaryData
    Darcs.Patch.TokenReplace Darcs.Patch.TouchesFiles
    Darcs.Patch.Unwind Darcs.Patch.V1 Darcs.Patch.V1.Apply
    Darcs.Patch.V1.Commute Darcs.Patch.V1.Core Darcs.Patch.V1.Prim
    Darcs.Patch.V1.Read Darcs.Patch.V1.Show Darcs.Patch.V1.Viewing
    Darcs.Patch.V2 Darcs.Patch.V2.Non Darcs.Patch.V2.Prim
    Darcs.Patch.V2.RepoPatch Darcs.Patch.V3 Darcs.Patch.V3.Contexted
    Darcs.Patch.V3.Core Darcs.Patch.V3.Resolution Darcs.Patch.Viewing
    Darcs.Patch.Witnesses.Eq Darcs.Patch.Witnesses.Maybe
    Darcs.Patch.Witnesses.Ordered Darcs.Patch.Witnesses.Sealed
    Darcs.Patch.Witnesses.Show Darcs.Patch.Witnesses.Unsafe
    Darcs.Patch.Witnesses.WZipper Darcs.Prelude Darcs.Repository
    Darcs.Repository.ApplyPatches Darcs.Repository.Cache
    Darcs.Repository.Clone Darcs.Repository.Create
    Darcs.Repository.Diff Darcs.Repository.Flags
    Darcs.Repository.Format Darcs.Repository.Hashed
    Darcs.Repository.HashedIO Darcs.Repository.Identify
    Darcs.Repository.InternalTypes Darcs.Repository.Inventory
    Darcs.Repository.Job Darcs.Repository.Match Darcs.Repository.Merge
    Darcs.Repository.Old Darcs.Repository.Packs
    Darcs.Repository.PatchIndex Darcs.Repository.Paths
    Darcs.Repository.Pending Darcs.Repository.Prefs
    Darcs.Repository.Pristine Darcs.Repository.Rebase
    Darcs.Repository.Repair Darcs.Repository.Resolution
    Darcs.Repository.State Darcs.Repository.Test
    Darcs.Repository.Traverse Darcs.Repository.Working
    Darcs.Test.TestOnly Darcs.UI.ApplyPatches Darcs.UI.Commands
    Darcs.UI.Commands.Add Darcs.UI.Commands.Amend
    Darcs.UI.Commands.Annotate Darcs.UI.Commands.Apply
    Darcs.UI.Commands.Clone Darcs.UI.Commands.Convert
    Darcs.UI.Commands.Convert.Darcs2 Darcs.UI.Commands.Convert.Export
    Darcs.UI.Commands.Convert.Import Darcs.UI.Commands.Convert.Util
    Darcs.UI.Commands.Diff Darcs.UI.Commands.Dist
    Darcs.UI.Commands.GZCRCs Darcs.UI.Commands.Help
    Darcs.UI.Commands.Init Darcs.UI.Commands.Log
    Darcs.UI.Commands.MarkConflicts Darcs.UI.Commands.Move
    Darcs.UI.Commands.Optimize Darcs.UI.Commands.Pull
    Darcs.UI.Commands.Push Darcs.UI.Commands.Rebase
    Darcs.UI.Commands.Record Darcs.UI.Commands.Remove
    Darcs.UI.Commands.Repair Darcs.UI.Commands.Replace
    Darcs.UI.Commands.Revert Darcs.UI.Commands.Rollback
    Darcs.UI.Commands.Send Darcs.UI.Commands.SetPref
    Darcs.UI.Commands.Show Darcs.UI.Commands.ShowAuthors
    Darcs.UI.Commands.ShowContents Darcs.UI.Commands.ShowDependencies
    Darcs.UI.Commands.ShowFiles Darcs.UI.Commands.ShowIndex
    Darcs.UI.Commands.ShowPatchIndex Darcs.UI.Commands.ShowRepo
    Darcs.UI.Commands.ShowTags Darcs.UI.Commands.Tag
    Darcs.UI.Commands.Test Darcs.UI.Commands.TransferMode
    Darcs.UI.Commands.Unrecord Darcs.UI.Commands.Unrevert
    Darcs.UI.Commands.Util Darcs.UI.Commands.Util.Tree
    Darcs.UI.Commands.WhatsNew Darcs.UI.Completion Darcs.UI.Defaults
    Darcs.UI.Email Darcs.UI.External Darcs.UI.Flags Darcs.UI.Options
    Darcs.UI.Options.All Darcs.UI.Options.Core Darcs.UI.Options.Flags
    Darcs.UI.Options.Iso Darcs.UI.Options.Markdown
    Darcs.UI.Options.Matching Darcs.UI.Options.Util
    Darcs.UI.PatchHeader Darcs.UI.PrintPatch Darcs.UI.RunCommand
    Darcs.UI.SelectChanges Darcs.UI.TheCommands Darcs.UI.Usage
    Darcs.Util.AtExit Darcs.Util.ByteString Darcs.Util.CommandLine
    Darcs.Util.Compat Darcs.Util.DateMatcher Darcs.Util.DateTime
    Darcs.Util.Diff Darcs.Util.Diff.Myers Darcs.Util.Diff.Patience
    Darcs.Util.Download Darcs.Util.Download.Request Darcs.Util.Encoding
    Darcs.Util.English Darcs.Util.Exception Darcs.Util.Exec
    Darcs.Util.External Darcs.Util.File Darcs.Util.Global
    Darcs.Util.Graph Darcs.Util.HTTP Darcs.Util.Hash Darcs.Util.Index
    Darcs.Util.IsoDate Darcs.Util.Lock Darcs.Util.Parser
    Darcs.Util.Path Darcs.Util.Printer Darcs.Util.Printer.Color
    Darcs.Util.Progress Darcs.Util.Prompt Darcs.Util.Ratified
    Darcs.Util.Show Darcs.Util.SignalHandler Darcs.Util.Ssh
    Darcs.Util.Tree Darcs.Util.Tree.Hashed Darcs.Util.Tree.Monad
    Darcs.Util.Tree.Plain Darcs.Util.URL Darcs.Util.Workaround

hidden-modules:       Version Darcs.Util.Download.Curl
import-dirs:          /usr/lib/ghc-8.10.5/site-local/darcs-2.16.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/darcs-2.16.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/darcs-2.16.4
hs-libraries:         HSdarcs-2.16.4-3xL19QV72jG2Nz62qck8cR
extra-libraries:      curl
depends:
    array-0.5.4.0 async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H
    attoparsec-0.14.1-CDW2c9fsk3y4jVQKNBcpib base-4.14.2.0
    base16-bytestring-1.0.1.0-HvKbW9RCiAQ5xlJPICEukR binary-0.8.8.0
    bytestring-0.10.12.0 conduit-1.3.4.1-GHgRKpknFuqDscwzVojbiE
    constraints-0.13-AnR9rNxGX5VB941qwyLpm4 containers-0.6.4.1
    cryptonite-0.29-KSQcZnQaH5M3lIm9Vzc7YS
    data-ordlist-0.4.7.0-GgrnRpConqG52QL2KvKvcm directory-1.3.6.0
    fgl-5.7.0.3-7QcjBlSkxRGItOSJY6uAQt filepath-1.4.2.1
    hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE haskeline-0.8.0.1
    html-1.0.1.2-2kC611sx9612OIqMFS65XS
    http-conduit-2.3.8-EHVj4SxGcYE5sNggtZCndH
    http-types-0.12.3-JSCBEGU6f6MIPS3hXwEPIB
    memory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S
    mmap-0.5.9-C5s42kGtD4bA1vzj3BcSvk mtl-2.2.2
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M
    network-uri-2.6.4.1-4m8gp52oIfHLdE9VhQrWxs
    old-time-1.1.0.3-L4487sR2g8B3hwiiVWHb93 parsec-3.1.14.0
    process-1.6.9.0 regex-applicative-0.3.4-HInkuhFU9gZJJQTDp94R7o
    regex-compat-tdfa-0.95.1.4-9JG6FMIGr3oGCEqOq6XLL0 stm-2.5.0.1
    tar-0.5.1.1-6maeBEHWG6qBgsBjggsuw3
    temporary-1.3-8GcUVXeVeMb6fVcXKNialU terminfo-0.4.1.4 text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2 unix-2.7.2.2
    unix-compat-0.5.3-1KqjYp6svTH6EdzCzH8QEz
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    zip-archive-0.4.1-8NGv2nxB6pDL75AFxe6s12
    zlib-0.6.2.3-GAUO2iiPelTDtuicMOd1b8

haddock-interfaces:   /usr/share/doc/darcs/html/darcs.haddock
haddock-html:         /usr/share/doc/darcs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

