/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.swing;

import com.jogamp.newt.Window;
import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.gl2.GLUT;
import java.awt.Container;
import java.awt.Dimension;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.swing.GLAbstractListener;

public class NewtGraphCanvas
extends GLAbstractListener {
    private final GLUT glut = new GLUT();
    private NewtCanvasAWT glCanvas;

    @Override
    protected GLAutoDrawable initDrawable() {
        GLWindow glWindow = GLWindow.create((GLCapabilitiesImmutable)this.getCaps());
        this.glCanvas = new HighDPIFixCanvas(glWindow);
        this.graphComponent = this.glCanvas;
        this.window = glWindow;
        return glWindow;
    }

    @Override
    protected void init(GL2 gl) {
        this.globalScale = (float)this.glCanvas.getGraphicsConfiguration().getDefaultTransform().getScaleX();
        this.engine.startDisplay();
    }

    @Override
    public void reinitWindow() {
        Container c;
        if (!UIUtils.isAquaLookAndFeel() && (c = this.graphComponent.getParent()) != null) {
            c.remove(this.graphComponent);
            c.add(this.graphComponent, "Center");
        }
    }

    @Override
    protected void render3DScene(GL2 gl, GLU glu) {
        if (this.vizController.getVizConfig().isShowFPS()) {
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glMatrixMode(5889);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glGetIntegerv(2978, this.viewport);
            glu.gluOrtho2D(0.0f, (float)this.viewport.get(2), (float)this.viewport.get(3), 0.0f);
            gl.glDepthFunc(519);
            gl.glColor3i(192, 192, 192);
            gl.glRasterPos2f(10.0f, (float)(15 + (this.getGlobalScale() > 1.0f ? 8 : 0)));
            String fpsRound = String.valueOf((int)this.fps);
            if (this.getGlobalScale() > 1.0f) {
                this.glut.glutBitmapString(8, fpsRound);
            } else {
                this.glut.glutBitmapString(6, fpsRound);
            }
            gl.glDepthFunc(513);
            gl.glPopMatrix();
            gl.glMatrixMode(5888);
            gl.glPopMatrix();
        }
    }

    @Override
    protected void reshape3DScene(GL2 gl) {
    }

    @Override
    public void destroy() {
        super.destroy();
        this.glCanvas.getNEWTChild().destroy();
        this.glCanvas = null;
    }

    public class HighDPIFixCanvas
    extends NewtCanvasAWT {
        public HighDPIFixCanvas(GLWindow glWindow) {
            super((Window)glWindow);
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(d.width, d.height);
        }

        public int getWidth() {
            return (int)((float)super.getWidth() * NewtGraphCanvas.this.getGlobalScale());
        }

        public int getHeight() {
            return (int)((float)super.getHeight() * NewtGraphCanvas.this.getGlobalScale());
        }
    }
}

