/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.text;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.gephi.ui.utils.ColorUtils;
import org.gephi.ui.utils.UIUtils;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.text.ColorMode;
import org.gephi.visualization.text.FixedSizeMode;
import org.gephi.visualization.text.ObjectColorMode;
import org.gephi.visualization.text.ProportionalSizeMode;
import org.gephi.visualization.text.ScaledSizeMode;
import org.gephi.visualization.text.SizeMode;
import org.gephi.visualization.text.TextColorMode;
import org.gephi.visualization.text.UniqueColorMode;
import org.openide.util.Lookup;

public class TextModelImpl {
    protected ColorMode colorMode;
    protected SizeMode sizeMode;
    protected boolean selectedOnly;
    protected boolean showNodeLabels;
    protected boolean showEdgeLabels;
    protected Font nodeFont;
    protected Font edgeFont;
    protected float[] nodeColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected float[] edgeColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected float nodeSizeFactor = 0.5f;
    protected float edgeSizeFactor = 0.5f;
    protected List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    protected Column[] nodeTextColumns = new Column[0];
    protected Column[] edgeTextColumns = new Column[0];

    public TextModelImpl() {
        this.defaultValues();
    }

    private void defaultValues() {
        VizConfig vizConfig = VizController.getInstance().getVizConfig();
        this.showNodeLabels = vizConfig.isDefaultShowNodeLabels();
        this.showEdgeLabels = vizConfig.isDefaultShowEdgeLabels();
        this.nodeFont = vizConfig.getDefaultNodeLabelFont();
        this.edgeFont = vizConfig.getDefaultEdgeLabelFont();
        this.nodeColor = UIUtils.isDarkLookAndFeel() ? vizConfig.getDefaultDarkNodeLabelColor().getRGBComponents(null) : vizConfig.getDefaultNodeLabelColor().getRGBComponents(null);
        this.edgeColor = vizConfig.getDefaultEdgeLabelColor().getRGBComponents(null);
        this.selectedOnly = vizConfig.isDefaultShowLabelOnSelectedOnly();
        this.colorMode = VizController.getInstance().getTextManager().getColorModes()[2];
        this.sizeMode = VizController.getInstance().getTextManager().getSizeModes()[1];
    }

    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        if (list != null) {
            this.listeners.add(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        if (list != null) {
            this.listeners.remove(changeListener);
        }
    }

    private void fireChangeEvent() {
        ChangeEvent evt = new ChangeEvent(this);
        List<ChangeListener> list = this.listeners;
        if (list != null) {
            for (ChangeListener l : list) {
                l.stateChanged(evt);
            }
        }
    }

    public List<ChangeListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<ChangeListener> listeners) {
        this.listeners = listeners;
    }

    public boolean isShowEdgeLabels() {
        return this.showEdgeLabels;
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        this.showEdgeLabels = showEdgeLabels;
        this.fireChangeEvent();
    }

    public boolean isShowNodeLabels() {
        return this.showNodeLabels;
    }

    public void setShowNodeLabels(boolean showNodeLabels) {
        this.showNodeLabels = showNodeLabels;
        this.fireChangeEvent();
    }

    public Font getEdgeFont() {
        return this.edgeFont;
    }

    public void setEdgeFont(Font edgeFont) {
        this.edgeFont = edgeFont;
        this.fireChangeEvent();
    }

    public float getEdgeSizeFactor() {
        return this.edgeSizeFactor;
    }

    public void setEdgeSizeFactor(float edgeSizeFactor) {
        this.edgeSizeFactor = edgeSizeFactor;
        this.fireChangeEvent();
    }

    public Font getNodeFont() {
        return this.nodeFont;
    }

    public void setNodeFont(Font nodeFont) {
        this.nodeFont = nodeFont;
        this.fireChangeEvent();
    }

    public float getNodeSizeFactor() {
        return this.nodeSizeFactor;
    }

    public void setNodeSizeFactor(float nodeSizeFactor) {
        this.nodeSizeFactor = nodeSizeFactor;
        this.fireChangeEvent();
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public void setColorMode(ColorMode colorMode) {
        this.colorMode = colorMode;
        this.fireChangeEvent();
    }

    public boolean isSelectedOnly() {
        return this.selectedOnly;
    }

    public void setSelectedOnly(boolean value) {
        this.selectedOnly = value;
        this.fireChangeEvent();
    }

    public SizeMode getSizeMode() {
        return this.sizeMode;
    }

    public void setSizeMode(SizeMode sizeMode) {
        this.sizeMode = sizeMode;
        this.fireChangeEvent();
    }

    public Color getNodeColor() {
        return new Color(this.nodeColor[0], this.nodeColor[1], this.nodeColor[2], this.nodeColor[3]);
    }

    public void setNodeColor(Color color) {
        this.nodeColor = color.getRGBComponents(null);
        this.fireChangeEvent();
    }

    public Color getEdgeColor() {
        return new Color(this.edgeColor[0], this.edgeColor[1], this.edgeColor[2], this.edgeColor[3]);
    }

    public void setEdgeColor(Color color) {
        this.edgeColor = color.getRGBComponents(null);
        this.fireChangeEvent();
    }

    public Column[] getEdgeTextColumns() {
        return this.edgeTextColumns;
    }

    public void setTextColumns(Column[] nodeTextColumns, Column[] edgeTextColumns) {
        this.nodeTextColumns = nodeTextColumns;
        this.edgeTextColumns = edgeTextColumns;
        this.fireChangeEvent();
    }

    public Column[] getNodeTextColumns() {
        return this.nodeTextColumns;
    }

    public void readXML(XMLStreamReader reader, Workspace workspace) throws XMLStreamException {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController != null ? graphController.getGraphModel(workspace) : null;
        ArrayList<Column> nodeCols = new ArrayList<Column>();
        ArrayList<Column> edgeCols = new ArrayList<Column>();
        boolean nodeColumn = false;
        boolean edgeColumn = false;
        boolean nodeSizeFac = false;
        boolean edgeSizeFac = false;
        boolean end = false;
        block5: while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    Column col;
                    String name = reader.getLocalName();
                    if ("shownodelabels".equalsIgnoreCase(name)) {
                        this.showNodeLabels = Boolean.parseBoolean(reader.getAttributeValue(null, "enable"));
                        break;
                    }
                    if ("showedgelabels".equalsIgnoreCase(name)) {
                        this.showEdgeLabels = Boolean.parseBoolean(reader.getAttributeValue(null, "enable"));
                        break;
                    }
                    if ("selectedOnly".equalsIgnoreCase(name)) {
                        this.selectedOnly = Boolean.parseBoolean(reader.getAttributeValue(null, "value"));
                        break;
                    }
                    if ("nodefont".equalsIgnoreCase(name)) {
                        String nodeFontName = reader.getAttributeValue(null, "name");
                        int nodeFontSize = Integer.parseInt(reader.getAttributeValue(null, "size"));
                        int nodeFontStyle = Integer.parseInt(reader.getAttributeValue(null, "style"));
                        this.nodeFont = new Font(nodeFontName, nodeFontStyle, nodeFontSize);
                        break;
                    }
                    if ("edgefont".equalsIgnoreCase(name)) {
                        String edgeFontName = reader.getAttributeValue(null, "name");
                        int edgeFontSize = Integer.parseInt(reader.getAttributeValue(null, "size"));
                        int edgeFontStyle = Integer.parseInt(reader.getAttributeValue(null, "style"));
                        this.edgeFont = new Font(edgeFontName, edgeFontStyle, edgeFontSize);
                        break;
                    }
                    if ("nodecolor".equalsIgnoreCase(name)) {
                        this.nodeColor = ColorUtils.decode((String)reader.getAttributeValue(null, "value")).getRGBComponents(null);
                        break;
                    }
                    if ("edgecolor".equalsIgnoreCase(name)) {
                        this.edgeColor = ColorUtils.decode((String)reader.getAttributeValue(null, "value")).getRGBComponents(null);
                        break;
                    }
                    if ("nodesizefactor".equalsIgnoreCase(name)) {
                        nodeSizeFac = true;
                        break;
                    }
                    if ("edgesizefactor".equalsIgnoreCase(name)) {
                        edgeSizeFac = true;
                        break;
                    }
                    if ("colormode".equalsIgnoreCase(name)) {
                        String colorModeClass = reader.getAttributeValue(null, "class");
                        if (colorModeClass.equals("TextColorMode")) {
                            this.colorMode = VizController.getInstance().getTextManager().getColorModes()[2];
                            break;
                        }
                        if (colorModeClass.equals("ObjectColorMode")) {
                            this.colorMode = VizController.getInstance().getTextManager().getColorModes()[1];
                            break;
                        }
                        this.colorMode = VizController.getInstance().getTextManager().getColorModes()[0];
                        break;
                    }
                    if ("sizemode".equalsIgnoreCase(name)) {
                        String sizeModeClass = reader.getAttributeValue(null, "class");
                        if (sizeModeClass.equals("FixedSizeMode")) {
                            this.sizeMode = VizController.getInstance().getTextManager().getSizeModes()[0];
                            break;
                        }
                        if (sizeModeClass.equals("ProportionalSizeMode")) {
                            this.sizeMode = VizController.getInstance().getTextManager().getSizeModes()[2];
                            break;
                        }
                        if (!sizeModeClass.equals("ScaledSizeMode")) continue block5;
                        this.sizeMode = VizController.getInstance().getTextManager().getSizeModes()[1];
                        break;
                    }
                    if ("nodecolumns".equalsIgnoreCase(name)) {
                        nodeColumn = true;
                        break;
                    }
                    if ("edgecolumns".equalsIgnoreCase(name)) {
                        edgeColumn = true;
                        break;
                    }
                    if (!"column".equalsIgnoreCase(name)) break;
                    String id = reader.getAttributeValue(null, "id");
                    if (nodeColumn && graphModel != null) {
                        Column col2 = graphModel.getNodeTable().getColumn(id);
                        if (col2 == null) continue block5;
                        nodeCols.add(col2);
                        break;
                    }
                    if (!edgeColumn || graphModel == null || (col = graphModel.getEdgeTable().getColumn(id)) == null) continue block5;
                    edgeCols.add(col);
                    break;
                }
                case 4: {
                    if (!reader.isWhiteSpace() && nodeSizeFac) {
                        this.nodeSizeFactor = Float.parseFloat(reader.getText());
                        break;
                    }
                    if (reader.isWhiteSpace() || !edgeSizeFac) break;
                    this.edgeSizeFactor = Float.parseFloat(reader.getText());
                    break;
                }
                case 2: {
                    nodeSizeFac = false;
                    edgeSizeFac = false;
                    if ("nodecolumns".equalsIgnoreCase(reader.getLocalName())) {
                        nodeColumn = false;
                        break;
                    }
                    if ("edgecolumns".equalsIgnoreCase(reader.getLocalName())) {
                        edgeColumn = false;
                        break;
                    }
                    if (!"textmodel".equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
        this.nodeTextColumns = nodeCols.toArray(new Column[0]);
        this.edgeTextColumns = edgeCols.toArray(new Column[0]);
    }

    public void writeXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("textmodel");
        writer.writeStartElement("shownodelabels");
        writer.writeAttribute("enable", String.valueOf(this.showNodeLabels));
        writer.writeEndElement();
        writer.writeStartElement("showedgelabels");
        writer.writeAttribute("enable", String.valueOf(this.showEdgeLabels));
        writer.writeEndElement();
        writer.writeStartElement("selectedOnly");
        writer.writeAttribute("value", String.valueOf(this.selectedOnly));
        writer.writeEndElement();
        writer.writeStartElement("nodefont");
        writer.writeAttribute("name", this.nodeFont.getName());
        writer.writeAttribute("size", Integer.toString(this.nodeFont.getSize()));
        writer.writeAttribute("style", Integer.toString(this.nodeFont.getStyle()));
        writer.writeEndElement();
        writer.writeStartElement("edgefont");
        writer.writeAttribute("name", this.edgeFont.getName());
        writer.writeAttribute("size", Integer.toString(this.edgeFont.getSize()));
        writer.writeAttribute("style", Integer.toString(this.edgeFont.getStyle()));
        writer.writeEndElement();
        writer.writeStartElement("nodesizefactor");
        writer.writeCharacters(String.valueOf(this.nodeSizeFactor));
        writer.writeEndElement();
        writer.writeStartElement("edgesizefactor");
        writer.writeCharacters(String.valueOf(this.edgeSizeFactor));
        writer.writeEndElement();
        writer.writeStartElement("nodecolor");
        writer.writeAttribute("value", ColorUtils.encode((Color)ColorUtils.decode((float[])this.nodeColor)));
        writer.writeEndElement();
        writer.writeStartElement("edgecolor");
        writer.writeAttribute("value", ColorUtils.encode((Color)ColorUtils.decode((float[])this.edgeColor)));
        writer.writeEndElement();
        writer.writeStartElement("colormode");
        if (this.colorMode instanceof UniqueColorMode) {
            writer.writeAttribute("class", "UniqueColorMode");
        } else if (this.colorMode instanceof ObjectColorMode) {
            writer.writeAttribute("class", "ObjectColorMode");
        } else if (this.colorMode instanceof TextColorMode) {
            writer.writeAttribute("class", "TextColorMode");
        }
        writer.writeEndElement();
        writer.writeStartElement("sizemode");
        if (this.sizeMode instanceof FixedSizeMode) {
            writer.writeAttribute("class", "FixedSizeMode");
        } else if (this.sizeMode instanceof ProportionalSizeMode) {
            writer.writeAttribute("class", "ProportionalSizeMode");
        } else if (this.sizeMode instanceof ScaledSizeMode) {
            writer.writeAttribute("class", "ScaledSizeMode");
        }
        writer.writeEndElement();
        writer.writeStartElement("nodecolumns");
        for (Column c : this.nodeTextColumns) {
            writer.writeStartElement("column");
            writer.writeAttribute("id", c.getId());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeStartElement("edgecolumns");
        for (Column c : this.edgeTextColumns) {
            writer.writeStartElement("column");
            writer.writeAttribute("id", c.getId());
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

