/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gephi.appearance.api.Partition;
import org.gephi.graph.api.Graph;

public abstract class PartitionImpl
implements Partition {
    protected final Map<Object, Color> colorMap = new HashMap<Object, Color>();

    protected PartitionImpl() {
    }

    @Override
    public Color getColor(Object value) {
        return this.colorMap.getOrDefault(value, Partition.DEFAULT_COLOR);
    }

    @Override
    public void setColor(Object value, Color color) {
        if (color.equals(Partition.DEFAULT_COLOR)) {
            this.colorMap.remove(value);
        } else {
            this.colorMap.put(value, color);
        }
    }

    @Override
    public void setColors(Graph graph, Color[] colors) {
        Collection sortedValues = this.getSortedValues(graph);
        Iterator itr = sortedValues.iterator();
        for (int i = 0; i < colors.length && itr.hasNext(); ++i) {
            this.setColor(itr.next(), colors[i]);
        }
    }

    @Override
    public Collection getSortedValues(Graph graph) {
        ArrayList values = new ArrayList(this.getValues(graph));
        values.sort((o1, o2) -> {
            int c1 = this.count(o1, graph);
            int c2 = this.count(o2, graph);
            return Integer.compare(c2, c1);
        });
        return values;
    }

    public abstract boolean isValid(Graph var1);

    public abstract Class getValueType();

    public abstract int getVersion(Graph var1);
}

