/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop.multilingual;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallableSystemAction;

public final class LanguageAction
extends CallableSystemAction {
    private static final String APPNAME = "gephi";

    public void performAction() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getName() {
        return NbBundle.getMessage(LanguageAction.class, (String)"CTL_LanguageAction");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getMenuPresenter() {
        JMenu menu = new JMenu(NbBundle.getMessage(LanguageAction.class, (String)"CTL_LanguageAction"));
        for (final Language lang : Language.values()) {
            ImageIcon icon;
            JMenuItem menuItem = new JMenuItem(new AbstractAction(lang.getName()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String msg = NbBundle.getMessage(LanguageAction.class, (String)"ChangeLang.Confirm.message");
                    String title = NbBundle.getMessage(LanguageAction.class, (String)"ChangeLang.Confirm.title");
                    NotifyDescriptor.Confirmation dd = new NotifyDescriptor.Confirmation((Object)msg, title, 0);
                    if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd).equals(DialogDescriptor.YES_OPTION)) {
                        try {
                            LanguageAction.this.setLanguage(lang);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(null, NbBundle.getMessage(LanguageAction.class, (String)"ChangeLang.Error.message"), NbBundle.getMessage(LanguageAction.class, (String)"ChangeLang.Confirm.title"), 0);
                        }
                    }
                }
            });
            String iconFile = "DesktopBranding/" + lang.getLanguage();
            if (lang.getCountry() != null) {
                iconFile = iconFile + "_" + lang.getCountry();
            }
            if ((icon = ImageUtilities.loadImageIcon((String)(iconFile = iconFile + ".png"), (boolean)false)) != null) {
                menuItem.setIcon(icon);
            }
            menu.add(menuItem);
        }
        return menu;
    }

    private void setLanguage(Language language) throws Exception {
        Object strLine;
        String homePath = Utilities.isMac() || Utilities.isUnix() ? System.getProperty("netbeans.home") : System.getProperty("user.dir");
        File etc = new File(homePath, "etc");
        if (!etc.exists()) {
            File base = new File(homePath).getParentFile();
            etc = new File(base, "etc");
        }
        File confFile = new File(etc, "gephi.conf");
        StringBuilder outputBuilder = new StringBuilder();
        String matchOptionsLine = "default_options=";
        BufferedReader reader = new BufferedReader(new FileReader(confFile));
        while ((strLine = reader.readLine()) != null) {
            if (((String)strLine).contains(matchOptionsLine)) {
                strLine = ((String)strLine).replaceAll(" -J-Duser\\.language=..", "");
                strLine = ((String)strLine).replaceAll(" -J-Duser\\.country=..", "");
                strLine = ((String)strLine).substring(0, ((String)strLine).lastIndexOf("\""));
                strLine = (String)strLine + " -J-Duser.language=" + language.getLanguage();
                if (language.getCountry() != null) {
                    strLine = (String)strLine + " -J-Duser.country=" + language.getCountry();
                }
                strLine = (String)strLine + "\"";
            }
            outputBuilder.append((String)strLine);
            outputBuilder.append("\n");
        }
        reader.close();
        FileWriter writer = new FileWriter(confFile);
        writer.write(outputBuilder.toString());
        writer.close();
        LifecycleManager.getDefault().exit();
    }

    public static enum Language {
        EN_US("en", "English"),
        CS_CS("cs", "\u010ce\u0161tina"),
        DE_DE("de", "Deutsch"),
        ES_ES("es", "Espa\u00f1ol"),
        FR_FR("fr", "Fran\u00e7ais"),
        PT_BR("pt", "BR", "Portugu\u00eas do Brasil"),
        RU_RU("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439"),
        ZH_CN("zh", "CN", "\u4e2d\u6587"),
        JA_JA("ja", "\u65e5\u672c\u8a9e"),
        RO_RO("ro", "Rom\u00e2n\u0103");

        private final String language;
        private String country = null;
        private final String name;

        private Language(String locale, String name) {
            this.language = locale;
            this.name = name;
        }

        private Language(String language, String country, String name) {
            this.language = language;
            this.name = name;
            this.country = country;
        }

        public String getName() {
            return this.name;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getCountry() {
            return this.country;
        }
    }
}

