#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 aeson-pretty
version:              0.8.8
visibility:           public
id:                   aeson-pretty-0.8.8-3aCNsqOVx5w7giic7jdZv7
key:                  aeson-pretty-0.8.8-3aCNsqOVx5w7giic7jdZv7
license:              BSD-3-Clause
copyright:            Copyright 2011 Falko Peters
maintainer:           Falko Peters <falko.peters@gmail.com>
author:               Falko Peters <falko.peters@gmail.com>
stability:            experimental
homepage:             http://github.com/informatikr/aeson-pretty
synopsis:             JSON pretty-printing library and command-line tool.
description:
    A JSON pretty-printing library compatible with aeson as well as
    a command-line tool to improve readabilty of streams of JSON data.

    The /library/ provides the function "encodePretty". It is a drop-in
    replacement for aeson'\''s "encode" function, producing JSON-ByteStrings for
    human readers.

    The /command-line tool/ reads JSON from stdin and writes prettified JSON
    to stdout. It also offers a complementary "compact"-mode, essentially the
    opposite of pretty-printing. If you specify @-flib-only@ like this

    > cabal install -flib-only aeson-pretty

    the command-line tool will NOT be installed.

category:             Text, Web, JSON, Pretty Printer
abi:                  5a4c385640d271b7e768291d647ba86b
exposed:              True
exposed-modules:      Data.Aeson.Encode.Pretty
import-dirs:          /usr/lib/ghc-8.10.5/site-local/aeson-pretty-0.8.8
library-dirs:         /usr/lib/ghc-8.10.5/site-local/aeson-pretty-0.8.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/aeson-pretty-0.8.8
hs-libraries:         HSaeson-pretty-0.8.8-3aCNsqOVx5w7giic7jdZv7
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ base-4.14.2.0
    base-compat-0.11.2-Eyusxyk2CrTGloLdon9bIK bytestring-0.10.12.0
    scientific-0.3.7.0-Fi0gRGhsiJ35wgbCjOXuHX text-1.2.4.1
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:
    /usr/share/doc/haskell-aeson-pretty/html/aeson-pretty.haddock

haddock-html:         /usr/share/doc/haskell-aeson-pretty/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

