#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.10.3
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:
    haskell-ci-0.10.3-GUbSe102l6l2Xo9V4TLAeI-haskell-ci-internal

key:
    haskell-ci-0.10.3-GUbSe102l6l2Xo9V4TLAeI-haskell-ci-internal

license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for [Travis-CI](https://travis-ci.org/) for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * macOS (OSX) support
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  f65f143ed89a7a7560a36d27799dc94a
exposed-modules:
    HaskellCI HaskellCI.Cli HaskellCI.Compiler HaskellCI.Config
    HaskellCI.Config.ConstraintSet HaskellCI.Config.CopyFields
    HaskellCI.Config.Doctest HaskellCI.Config.Dump
    HaskellCI.Config.Folds HaskellCI.Config.HLint
    HaskellCI.Config.Installed HaskellCI.Config.Jobs
    HaskellCI.Config.PackageScope HaskellCI.Config.Ubuntu
    HaskellCI.Diagnostics HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-8.10.5/site-local/haskell-ci-0.10.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/haskell-ci-0.10.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/haskell-ci-0.10.3
hs-libraries:
    HShaskell-ci-0.10.3-GUbSe102l6l2Xo9V4TLAeI-haskell-ci-internal

depends:
    Cabal-3.2.1.0 HsYAML-0.2.1.0-IrgXI27PLYW3CzfnbyjQV0
    ShellCheck-0.7.2-7UXTS6gTfzJLPax1UAQG45
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ base-4.14.2.0
    base-compat-0.11.2-Eyusxyk2CrTGloLdon9bIK bytestring-0.10.12.0
    cabal-install-parsers-0.4-K0jjlQqXhvsETiQXzRXir6 containers-0.6.4.1
    deepseq-1.4.4.0 directory-1.3.6.0 exceptions-0.10.4
    filepath-1.4.2.1 generic-lens-lite-0.1-pOYK5JslTVFaCj4MOLD0j
    lattices-2.0.2-2AKVanqjmthBkDzHIIHAtE mtl-2.2.2
    network-uri-2.6.4.1-4m8gp52oIfHLdE9VhQrWxs
    optparse-applicative-0.16.1.0-ARX6qDeExVWDKYrQ55nL8e
    parsec-3.1.14.0 pretty-1.1.3.6 process-1.6.9.0
    temporary-1.3-8GcUVXeVeMb6fVcXKNialU text-1.2.4.1
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

