#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 vec
version:              0.4
visibility:           public
id:                   vec-0.4-LJY3nuJ0tC5L6PUX7GwxMx
key:                  vec-0.4-LJY3nuJ0tC5L6PUX7GwxMx
license:              BSD-3-Clause
copyright:            (c) 2017-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Vec: length-indexed (sized) list
description:
    This package provides length-indexed (sized) lists, also known as vectors.

    @
    data Vec n a where
    \    VNil  :: Vec '\''Nat.Z a
    \    (:::) :: a -> Vec n a -> Vec ('\''Nat.S n) a
    @

    The functions are implemented in four flavours:

    * __naive__: with explicit recursion. It'\''s simple, constraint-less, yet slow.

    * __pull__: using @Fin n -> a@ representation, which fuses well,
    but makes some programs hard to write. And

    * __data-family__: which allows lazy pattern matching

    * __inline__: which exploits how GHC dictionary inlining works, unrolling
    recursion if the size of '\''Vec'\'' is known statically.

    As best approach depends on the application, @vec@ doesn'\''t do any magic
    transformation. Benchmark your code.

    This package uses [fin](https://hackage.haskell.org/package/fin), i.e. not @GHC.TypeLits@, for indexes.

    For @lens@ or @optics@ support see [vec-lens](https://hackage.haskell.org/package/vec-lens) and [vec-optics](https://hackage.haskell.org/package/vec-optics) packages respectively.

    See [Hasochism: the pleasure and pain of dependently typed haskell programming](https://doi.org/10.1145/2503778.2503786)
    by Sam Lindley and Conor McBride for answers to /how/ and /why/.
    Read [APLicative Programming with Naperian Functors](https://doi.org/10.1007/978-3-662-54434-1_21)
    by Jeremy Gibbons for (not so) different ones.

    === Similar packages

    * [linear](https://hackage.haskell.org/package/linear) has '\''V'\'' type,
    which uses '\''Vector'\'' from @vector@ package as backing store.
    @Vec@ is a real GADT, but tries to provide as many useful instances (upto @lens@).

    * [vector-sized](https://hackage.haskell.org/package/vector-sized)
    Great package using @GHC.TypeLits@. Current version (0.6.1.0) uses
    @finite-typelits@ and @Int@ indexes.

    * [sized-vector](https://hackage.haskell.org/package/sized-vector) depends
    on @singletons@ package. @vec@ isn'\''t light on dependencies either,
    but try to provide wide GHC support.

    * [fixed-vector](https://hackage.haskell.org/package/fixed-vector)

    * [sized](https://hackage.haskell.org/package/sized) also depends
    on a @singletons@ package. The @Sized f n a@ type is generalisation of
    @linear@'\''s @V@ for any @ListLike@.

    * [clash-prelude](https://hackage.haskell.org/package/clash-prelude)
    is a kitchen sink package, which has @CLaSH.Sized.Vector@ module.
    Also depends on @singletons@.

category:             Data, Dependent Types
abi:                  9b0ab4f9ad22fa77bc224fe47b18c0a7
exposed:              True
exposed-modules:
    Data.Vec.DataFamily.SpineStrict
    Data.Vec.DataFamily.SpineStrict.Pigeonhole Data.Vec.Lazy
    Data.Vec.Lazy.Inline Data.Vec.Pull

hidden-modules:       Control.Lens.Yocto Data.Functor.Confusing
import-dirs:          /usr/lib/ghc-8.10.5/site-local/vec-0.4
library-dirs:         /usr/lib/ghc-8.10.5/site-local/vec-0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/vec-0.4
hs-libraries:         HSvec-0.4-LJY3nuJ0tC5L6PUX7GwxMx
depends:
    QuickCheck-2.14.2-AlBcjlnVb6HBYuJ8lOviFD
    adjunctions-4.4-JRhSdN3HRQOD6xSzUIRHXY base-4.14.2.0
    deepseq-1.4.4.0 distributive-0.6.2.1-6MQhqQv9qsK3Nta0Xf3c3I
    fin-0.2-Jh4GoCBalwdLRITRmOhXo2
    hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE
    indexed-traversable-0.1.1-1Z2GfU1EWlL3ZzMnGNHsA4
    semigroupoids-5.3.5-CXCAmgAqO2AH1F4bh8bCjo transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/haskell-vec/html/vec.haddock
haddock-html:         /usr/share/doc/haskell-vec/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

