#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 zip-archive
version:              0.4.1
visibility:           public
id:                   zip-archive-0.4.1-8NGv2nxB6pDL75AFxe6s12
key:                  zip-archive-0.4.1-8NGv2nxB6pDL75AFxe6s12
license:              BSD-3-Clause
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             http://github.com/jgm/zip-archive
synopsis:             Library for creating and modifying zip archives.
description:
    The zip-archive library provides functions for creating, modifying, and
    extracting files from zip archives. The zip archive format is
    documented in <http://www.pkware.com/documents/casestudies/APPNOTE.TXT>.

    Certain simplifying assumptions are made about the zip archives: in
    particular, there is no support for strong encryption, zip files that
    span multiple disks, ZIP64, OS-specific file attributes, or compression
    methods other than Deflate. However, the library should be able to read
    the most common zip archives, and the archives it produces should be
    readable by all standard unzip programs.

    Archives are built and extracted in memory, so manipulating large zip
    files will consume a lot of memory. If you work with large zip files or
    need features not supported by this library, a better choice may be
    <http://hackage.haskell.org/package/zip zip>, which uses a
    memory-efficient streaming approach. However, zip can only read and
    write archives inside instances of MonadIO, so zip-archive is a better
    choice if you want to manipulate zip archives in "pure" contexts.

    As an example of the use of the library, a standalone zip archiver and
    extracter is provided in the source distribution.

category:             Codec
abi:                  09cdc299a7265261755112994b525cca
exposed:              True
exposed-modules:      Codec.Archive.Zip
import-dirs:          /usr/lib/ghc-8.10.5/site-local/zip-archive-0.4.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/zip-archive-0.4.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/zip-archive-0.4.1
hs-libraries:         HSzip-archive-0.4.1-8NGv2nxB6pDL75AFxe6s12
depends:
    array-0.5.4.0 base-4.14.2.0 binary-0.8.8.0 bytestring-0.10.12.0
    containers-0.6.4.1 digest-0.0.1.2-HzTusmq5AUc14HOafUvYmM
    directory-1.3.6.0 filepath-1.4.2.1 mtl-2.2.2 pretty-1.1.3.6
    text-1.2.4.1 time-1.9.3 unix-2.7.2.2
    zlib-0.6.2.3-GAUO2iiPelTDtuicMOd1b8

haddock-interfaces:   /usr/share/doc/haskell-zip-archive/html/zip-archive.haddock
haddock-html:         /usr/share/doc/haskell-zip-archive/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

