/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.jnlp.security.policyeditor.KeystoreInfo;
import net.sourceforge.jnlp.security.policyeditor.PermissionActions;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyIdentifier;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.MD5SumWatcher;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.security.provider.PolicyParser;

public class PolicyFileModel {
    private File file;
    private final Map<PolicyIdentifier, Map<PolicyEditorPermissions, Boolean>> permissionsMap = Collections.synchronizedMap(new HashMap());
    private final Map<PolicyIdentifier, Set<PolicyParser.PermissionEntry>> customPermissionsMap = Collections.synchronizedMap(new HashMap());
    private KeystoreInfo keystoreInfo = new KeystoreInfo(null, null, null, null);
    private MD5SumWatcher fileWatcher;
    private PolicyParser parser = new PolicyParser(false);

    PolicyFileModel(String filepath) {
        this(new File(filepath));
    }

    PolicyFileModel(File file) {
        this.setFile(file);
    }

    PolicyFileModel() {
    }

    synchronized boolean setFile(File file) {
        this.file = file;
        boolean sameFile = Objects.equals(this.file, file);
        return !sameFile;
    }

    synchronized File getFile() {
        return this.file;
    }

    synchronized PolicyParser getParser() {
        return this.parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void openAndParsePolicyFile() throws IOException, PolicyParser.ParsingException {
        this.parser = new PolicyParser(false);
        this.fileWatcher = new MD5SumWatcher(this.file);
        this.fileWatcher.update();
        this.clearPermissions();
        FileLock fileLock = FileUtils.getFileLock(this.file.getAbsolutePath(), false, true);
        try {
            this.parser.read(new FileReader(this.file));
            this.keystoreInfo = new KeystoreInfo(this.parser.getKeyStoreUrl(), this.parser.getKeyStoreType(), this.parser.getKeyStoreProvider(), this.parser.getStorePassURL());
            HashSet<PolicyParser.GrantEntry> grantEntries = new HashSet<PolicyParser.GrantEntry>(Collections.list(this.parser.grantElements()));
            Map<PolicyIdentifier, Map<PolicyEditorPermissions, Boolean>> map = this.permissionsMap;
            synchronized (map) {
                Map<PolicyIdentifier, Set<PolicyParser.PermissionEntry>> map2 = this.customPermissionsMap;
                synchronized (map2) {
                    for (PolicyParser.GrantEntry grantEntry : grantEntries) {
                        PolicyIdentifier policyIdentifier = new PolicyIdentifier(grantEntry.signedBy, grantEntry.principals, grantEntry.codeBase);
                        if (PolicyIdentifier.isDefaultPolicyIdentifier(policyIdentifier)) {
                            policyIdentifier = PolicyIdentifier.ALL_APPLETS_IDENTIFIER;
                        }
                        this.addIdentifier(policyIdentifier);
                        for (PolicyParser.PermissionEntry permissionEntry : grantEntry.permissionEntries) {
                            PolicyEditorPermissions editorPermissions = PolicyEditorPermissions.fromPermissionEntry(permissionEntry);
                            if (editorPermissions != null) {
                                this.permissionsMap.get(policyIdentifier).put(editorPermissions, true);
                                continue;
                            }
                            this.customPermissionsMap.get(policyIdentifier).add(permissionEntry);
                        }
                    }
                }
            }
        }
        finally {
            try {
                fileLock.release();
            }
            catch (IOException e) {
                OutputController.getLogger().log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void savePolicyFile() throws IOException {
        this.parser = new PolicyParser(false);
        FileLock fileLock = null;
        try {
            fileLock = FileUtils.getFileLock(this.file.getAbsolutePath(), false, true);
            Map<PolicyIdentifier, Map<PolicyEditorPermissions, Boolean>> map = this.permissionsMap;
            synchronized (map) {
                for (PolicyIdentifier identifier : this.permissionsMap.keySet()) {
                    String codebase = identifier.getCodebase().isEmpty() ? null : identifier.getCodebase();
                    PolicyParser.GrantEntry grantEntry = new PolicyParser.GrantEntry(identifier.getSignedBy(), codebase);
                    for (Map.Entry<PolicyEditorPermissions, Boolean> entry : this.permissionsMap.get(identifier).entrySet()) {
                        if (!entry.getValue().booleanValue()) continue;
                        PolicyEditorPermissions permission = entry.getKey();
                        String actionsString = permission.getActions().equals((Object)PermissionActions.NONE) ? null : permission.getActions().rawString();
                        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(permission.getType().type, permission.getTarget().target, actionsString);
                        grantEntry.add(permissionEntry);
                    }
                    for (PolicyParser.PermissionEntry customPermission : this.customPermissionsMap.get(identifier)) {
                        grantEntry.add(customPermission);
                    }
                    grantEntry.principals.addAll(identifier.getPrincipals());
                    this.parser.add(grantEntry);
                }
            }
            this.parser.write(new FileWriter(this.file));
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
        }
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (IOException e) {
                    OutputController.getLogger().log(e);
                }
            }
        }
        this.fileWatcher = new MD5SumWatcher(this.file);
        this.fileWatcher.update();
    }

    synchronized boolean hasChanged() throws IOException {
        return this.fileWatcher != null && this.fileWatcher.update();
    }

    synchronized SortedSet<PolicyIdentifier> getIdentifiers() {
        return new TreeSet<PolicyIdentifier>(this.permissionsMap.keySet());
    }

    synchronized KeystoreInfo getKeystoreInfo() {
        return this.keystoreInfo;
    }

    synchronized boolean addIdentifier(PolicyIdentifier identifier) {
        Objects.requireNonNull(identifier);
        boolean existingCodebase = true;
        if (!this.permissionsMap.containsKey(identifier)) {
            HashMap<PolicyEditorPermissions, Boolean> map = new HashMap<PolicyEditorPermissions, Boolean>();
            for (PolicyEditorPermissions perm : PolicyEditorPermissions.values()) {
                map.put(perm, false);
            }
            this.permissionsMap.put(identifier, map);
            existingCodebase = false;
        }
        if (!this.customPermissionsMap.containsKey(identifier)) {
            this.customPermissionsMap.put(identifier, new HashSet());
            existingCodebase = false;
        }
        return existingCodebase;
    }

    synchronized void clearPermissions() {
        this.permissionsMap.clear();
        this.clearCustomPermissions();
    }

    synchronized void removeIdentifier(PolicyIdentifier identifier) {
        Objects.requireNonNull(identifier);
        this.permissionsMap.remove(identifier);
        this.customPermissionsMap.remove(identifier);
    }

    synchronized void setPermission(PolicyIdentifier identifier, PolicyEditorPermissions permission, boolean state) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(permission);
        this.addIdentifier(identifier);
        this.permissionsMap.get(identifier).put(permission, state);
    }

    synchronized boolean getPermission(PolicyIdentifier identifier, PolicyEditorPermissions permission) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(permission);
        if (!this.permissionsMap.containsKey(identifier)) {
            return false;
        }
        return this.permissionsMap.get(identifier).get(permission);
    }

    synchronized Map<PolicyIdentifier, Map<PolicyEditorPermissions, Boolean>> getCopyOfPermissions() {
        return new HashMap<PolicyIdentifier, Map<PolicyEditorPermissions, Boolean>>(this.permissionsMap);
    }

    synchronized void clearCustomPermissions() {
        this.customPermissionsMap.clear();
    }

    synchronized void clearCustomIdentifier(PolicyIdentifier identifier) {
        Objects.requireNonNull(identifier);
        if (!this.customPermissionsMap.containsKey(identifier)) {
            return;
        }
        this.customPermissionsMap.get(identifier).clear();
    }

    synchronized void addCustomPermissions(PolicyIdentifier identifier, Collection<? extends PolicyParser.PermissionEntry> permissions) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(permissions);
        this.addIdentifier(identifier);
        this.customPermissionsMap.get(identifier).addAll(permissions);
    }

    synchronized Map<PolicyIdentifier, Set<PolicyParser.PermissionEntry>> getCopyOfCustomPermissions() {
        return new HashMap<PolicyIdentifier, Set<PolicyParser.PermissionEntry>>(this.customPermissionsMap);
    }
}

