/*
 * Decompiled with CFR 0.152.
 */
package net.sf.juife;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;

public class JuifeUtils {
    private JuifeUtils() {
    }

    public static Point centerLocation(Component component, Component parent) {
        int x = parent.getLocation().x;
        int y = parent.getLocation().y;
        int w = parent.getBounds().width;
        int h = parent.getBounds().height;
        Rectangle r = component.getBounds();
        w -= r.width;
        h -= r.height;
        y += (h /= 2);
        if ((x += (w /= 2)) < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        return new Point(x, y);
    }

    public static Dimension getUnionSize(Component c1, Component c2) {
        return JuifeUtils.getUnionSize(c1.getPreferredSize(), c2.getPreferredSize());
    }

    public static Dimension getUnionSize(Component c1, Dimension d2) {
        return JuifeUtils.getUnionSize(c1.getPreferredSize(), d2);
    }

    public static Dimension getUnionSize(Dimension d1, Dimension d2) {
        return new Dimension(Math.max(d1.width, d2.width), Math.max(d1.height, d2.height));
    }

    public static Window getWindow(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof Frame || c instanceof Dialog) {
            return (Window)c;
        }
        return JuifeUtils.getWindow(c.getParent());
    }
}

