/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.juife.ComponentList;
import net.sf.juife.DefaultComponentListModel;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jsampler.CC;
import org.jsampler.MidiDeviceModel;
import org.jsampler.event.MidiDeviceListEvent;
import org.jsampler.event.MidiDeviceListListener;
import org.jsampler.task.Midi;
import org.jsampler.view.JSViewConfig;
import org.jsampler.view.SessionViewConfig;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.MidiDevicePane;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.PixmapButton;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.jsampler.view.std.JSNewMidiDeviceDlg;
import org.linuxsampler.lscp.MidiInputDriver;

public class MidiDevicesPane
extends JPanel {
    private final DeviceListPane devList = new DeviceListPane();
    private final DefaultComponentListModel<MidiDevicePane> listModel = new DefaultComponentListModel();
    private final EventHandler eventHandler = new EventHandler();

    public MidiDevicesPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.devList.setModel(this.listModel);
        this.devList.setSelectionMode(0);
        this.devList.setAlignmentX(0.0f);
        this.add(this.devList);
        this.add(new NewDevicePane());
        CC.getSamplerModel().addMidiDeviceListListener(this.getHandler());
        for (MidiDeviceModel midiDeviceModel : CC.getSamplerModel().getMidiDevices()) {
            this.addDevice(midiDeviceModel);
        }
    }

    public int getDevicePaneCount() {
        return this.listModel.size();
    }

    public MidiDevicePane getDevicePaneAt(int n) {
        return this.listModel.get(n);
    }

    private void addDevice(MidiDeviceModel midiDeviceModel) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (this.listModel.get(i).getDeviceId() != midiDeviceModel.getDeviceId()) continue;
            CC.getLogger().warning("MIDI device exist: " + midiDeviceModel.getDeviceId());
            return;
        }
        MidiDevicePane midiDevicePane = new MidiDevicePane(midiDeviceModel);
        SessionViewConfig.DeviceConfig deviceConfig = null;
        JSViewConfig jSViewConfig = CC.getViewConfig();
        if (jSViewConfig != null && jSViewConfig.getSessionViewConfig() != null) {
            deviceConfig = jSViewConfig.getSessionViewConfig().pollMidiDeviceConfig();
        }
        if (deviceConfig != null && deviceConfig.expanded) {
            midiDevicePane.showOptionsPane(true);
        }
        this.listModel.add(midiDevicePane);
    }

    private void removeDevice(MidiDeviceModel midiDeviceModel) {
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            if (this.listModel.get(i).getDeviceId() != midiDeviceModel.getDeviceId()) continue;
            this.listModel.remove(i);
            return;
        }
        CC.getLogger().warning("MIDI device does not exist: " + midiDeviceModel.getDeviceId());
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    implements MidiDeviceListListener {
        private EventHandler() {
        }

        @Override
        public void deviceAdded(MidiDeviceListEvent midiDeviceListEvent) {
            MidiDevicesPane.this.addDevice(midiDeviceListEvent.getMidiDeviceModel());
        }

        @Override
        public void deviceRemoved(MidiDeviceListEvent midiDeviceListEvent) {
            MidiDevicesPane.this.removeDevice(midiDeviceListEvent.getMidiDeviceModel());
        }
    }

    class NewDevicePane
    extends FantasiaPanel {
        private final PixmapButton btnNew = new PixmapButton(Res.gfxPowerOff18);
        private JXCollapsiblePane createDevicePane = null;
        private boolean createDevice = false;

        NewDevicePane() {
            this.setLayout(new BorderLayout());
            PixmapPane pixmapPane = new PixmapPane(Res.gfxDeviceBg);
            pixmapPane.setPixmapInsets(new Insets(1, 1, 1, 1));
            pixmapPane.setLayout(new BoxLayout(pixmapPane, 0));
            pixmapPane.add(Box.createRigidArea(new Dimension(3, 0)));
            pixmapPane.add(this.btnNew);
            pixmapPane.add(Box.createRigidArea(new Dimension(3, 0)));
            pixmapPane.add(this.createVSeparator());
            Dimension dimension = new Dimension(77, 24);
            pixmapPane.setPreferredSize(dimension);
            pixmapPane.setMinimumSize(dimension);
            pixmapPane.setMaximumSize(new Dimension(Short.MAX_VALUE, 24));
            this.btnNew.setPressedIcon(Res.gfxPowerOn18);
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewDevicePane.this.showHidePopup();
                }
            });
            pixmapPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() != 1) {
                        return;
                    }
                    NewDevicePane.this.showHidePopup();
                }
            });
            pixmapPane.setCursor(Cursor.getPredefinedCursor(12));
            String string = FantasiaI18n.i18n.getLabel("MidiDevicesPane.newDevice");
            this.btnNew.setToolTipText(string);
            pixmapPane.setToolTipText(string);
            this.add((Component)pixmapPane, "North");
            this.setAlignmentX(0.0f);
        }

        private JPanel createVSeparator() {
            PixmapPane pixmapPane = new PixmapPane(Res.gfxVLine);
            pixmapPane.setOpaque(false);
            pixmapPane.setPreferredSize(new Dimension(2, 24));
            pixmapPane.setMinimumSize(pixmapPane.getPreferredSize());
            pixmapPane.setMaximumSize(pixmapPane.getPreferredSize());
            return pixmapPane;
        }

        private JXCollapsiblePane getCreateDevicePane() {
            if (this.createDevicePane != null) {
                return this.createDevicePane;
            }
            this.createDevicePane = new JXCollapsiblePane();
            final JSNewMidiDeviceDlg.Pane pane = new JSNewMidiDeviceDlg.Pane();
            PixmapPane pixmapPane = new PixmapPane(Res.gfxChannelOptions);
            pixmapPane.setPixmapInsets(new Insets(1, 1, 1, 1));
            pixmapPane.setLayout(new BorderLayout());
            pixmapPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            PixmapPane pixmapPane2 = new PixmapPane(Res.gfxBorder);
            pixmapPane2.setPixmapInsets(new Insets(1, 1, 1, 1));
            pixmapPane2.setLayout(new BorderLayout());
            pixmapPane2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            pixmapPane2.add(pane);
            pixmapPane.add(pixmapPane2);
            pixmapPane.setPreferredSize(new Dimension(this.getWidth(), 210));
            pixmapPane.setPreferredSize(new Dimension(100, 210));
            this.createDevicePane.setContentPane(pixmapPane);
            this.createDevicePane.setAnimated(false);
            this.createDevicePane.setCollapsed(true);
            this.createDevicePane.setAnimated(FantasiaPrefs.preferences().getBoolProperty("animated"));
            FantasiaPrefs.preferences().addPropertyChangeListener("animated", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    boolean bl = FantasiaPrefs.preferences().getBoolProperty("animated");
                    NewDevicePane.this.createDevicePane.setAnimated(bl);
                }
            });
            String string = "animationState";
            this.createDevicePane.addPropertyChangeListener(string, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object == "collapsed") {
                        if (NewDevicePane.this.createDevice) {
                            NewDevicePane.this.createMidiDevice0(pane);
                            NewDevicePane.this.createDevice = false;
                        }
                    } else if (object == "expanded" || object == "expanding/collapsing") {
                        NewDevicePane.this.ensureCreateDevicePaneIsVisible();
                    }
                }
            });
            this.add(this.createDevicePane);
            pane.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewDevicePane.this.createDevicePane.setCollapsed(true);
                }
            });
            pane.btnCreate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NewDevicePane.this.createMidiDevice(pane);
                }
            });
            return this.createDevicePane;
        }

        private void showHidePopup() {
            if (!CC.verifyConnection()) {
                return;
            }
            this.getCreateDevicePane().setCollapsed(!this.getCreateDevicePane().isCollapsed());
        }

        private void createMidiDevice(JSNewMidiDeviceDlg.Pane pane) {
            if (!this.createDevicePane.isAnimated()) {
                this.createMidiDevice0(pane);
                return;
            }
            this.createDevice = true;
            this.createDevicePane.setCollapsed(true);
        }

        private void createMidiDevice0(final JSNewMidiDeviceDlg.Pane pane) {
            pane.btnCreate.setEnabled(false);
            MidiInputDriver midiInputDriver = pane.getSelectedDriver();
            Midi.CreateDevice createDevice = new Midi.CreateDevice(midiInputDriver.getName(), pane.getParameters());
            createDevice.addTaskListener(new TaskListener(){

                @Override
                public void taskPerformed(TaskEvent taskEvent) {
                    pane.btnCreate.setEnabled(true);
                    NewDevicePane.this.getCreateDevicePane().setCollapsed(true);
                }
            });
            CC.getTaskQueue().add(createDevice);
        }

        private void ensureCreateDevicePaneIsVisible() {
            JScrollPane jScrollPane = null;
            int n = this.createDevicePane.getLocation().y + this.createDevicePane.getHeight();
            for (Container container = this.createDevicePane.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JScrollPane) {
                    jScrollPane = (JScrollPane)container;
                    break;
                }
                n += container.getLocation().y;
            }
            if (jScrollPane == null) {
                return;
            }
            jScrollPane.getViewport().scrollRectToVisible(new Rectangle(0, n, 5, 5));
        }
    }

    class DeviceListPane
    extends ComponentList {
        private Dimension maxSize = new Dimension();

        DeviceListPane() {
        }

        @Override
        public Dimension getMaximumSize() {
            this.maxSize.width = Short.MAX_VALUE;
            this.maxSize.height = this.getPreferredSize().height;
            return this.maxSize;
        }
    }
}

