/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.ByteArrayInputStream;
import java.io.FilePermission;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.languagetool.rules.patterns.PatternRuleLoader;

public class PatternRuleLoaderPermissionTest {
    private static final SecurityManager secManager = System.getSecurityManager();

    @BeforeClass
    public static void startup() throws Exception {
        Policy.setPolicy(new MyPolicy());
        System.setSecurityManager(new SecurityManager());
    }

    @Ignore(value="doesn't work with Gradle, see http://stackoverflow.com/questions/32584997/; also caused seemingly random exceptions after PR #1443 was merged")
    @Test
    public void testPermissionManager() throws Exception {
        try {
            PatternRuleLoader loader = new PatternRuleLoader();
            loader.getRules((InputStream)new ByteArrayInputStream("<rules lang='xx'></rules>".getBytes("utf-8")), "fakeName", null);
        }
        finally {
            System.setSecurityManager(null);
        }
    }

    @AfterClass
    public static void shutdown() {
        System.setSecurityManager(secManager);
    }

    static class MyPermissionCollection
    extends PermissionCollection {
        private final List<Permission> perms = new ArrayList<Permission>();

        MyPermissionCollection() {
        }

        @Override
        public void add(Permission p) {
            this.perms.add(p);
        }

        @Override
        public boolean implies(Permission p) {
            for (Permission perm : this.perms) {
                if (!perm.implies(p)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return Collections.enumeration(this.perms);
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }
    }

    static class MyPolicy
    extends Policy {
        MyPolicy() {
        }

        @Override
        public PermissionCollection getPermissions(CodeSource codesource) {
            MyPermissionCollection perms = new MyPermissionCollection();
            ((PermissionCollection)perms).add(new RuntimePermission("setIO"));
            ((PermissionCollection)perms).add(new RuntimePermission("setSecurityManager"));
            ((PermissionCollection)perms).add(new FilePermission("<<ALL FILES>>", "read"));
            return perms;
        }
    }
}

