/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.xerial.snappy.PureJavaCrc32C;

final class SnappyFramed {
    public static final int COMPRESSED_DATA_FLAG = 0;
    public static final int UNCOMPRESSED_DATA_FLAG = 1;
    public static final int STREAM_IDENTIFIER_FLAG = 255;
    private static final int MASK_DELTA = -1568478504;
    public static final byte[] HEADER_BYTES = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};

    SnappyFramed() {
    }

    public static int maskedCrc32c(byte[] data) {
        return SnappyFramed.maskedCrc32c(data, 0, data.length);
    }

    public static int maskedCrc32c(byte[] data, int offset, int length) {
        PureJavaCrc32C crc32c = new PureJavaCrc32C();
        crc32c.update(data, offset, length);
        return SnappyFramed.mask(crc32c.getIntegerValue());
    }

    public static int mask(int crc) {
        return (crc >>> 15 | crc << 17) + -1568478504;
    }

    static final int readBytes(ReadableByteChannel source, ByteBuffer dest) throws IOException {
        int lastRead;
        int expectedLength = dest.remaining();
        int totalRead = 0;
        totalRead = lastRead = source.read(dest);
        if (lastRead < expectedLength) {
            while (dest.remaining() != 0 && lastRead != -1) {
                lastRead = source.read(dest);
                if (lastRead == -1) continue;
                totalRead += lastRead;
            }
        }
        if (totalRead > 0) {
            dest.limit(dest.position());
        } else {
            dest.position(dest.limit());
        }
        return totalRead;
    }

    static int skip(ReadableByteChannel source, int skip, ByteBuffer buffer) throws IOException {
        if (skip <= 0) {
            return 0;
        }
        int toSkip = skip;
        int skipped = 0;
        while (toSkip > 0 && skipped != -1) {
            buffer.clear();
            if (toSkip < buffer.capacity()) {
                buffer.limit(toSkip);
            }
            if ((skipped = source.read(buffer)) <= 0) continue;
            toSkip -= skipped;
        }
        buffer.clear();
        return skip - toSkip;
    }
}

