/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.solaris;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum Fcntl implements Constant
{
    F_DUPFD(0L),
    F_GETFD(1L),
    F_SETFD(2L),
    F_GETFL(3L),
    F_SETFL(4L),
    F_GETOWN(23L),
    F_SETOWN(24L),
    F_GETLK(14L),
    F_SETLK(6L),
    F_SETLKW(7L),
    F_RDLCK(1L),
    F_UNLCK(3L),
    F_WRLCK(2L);

    private final long value;
    public static final long MIN_VALUE = 0L;
    public static final long MAX_VALUE = 24L;

    private Fcntl(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<Fcntl, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<Fcntl, String> generateTable() {
            EnumMap<Fcntl, String> map2 = new EnumMap<Fcntl, String>(Fcntl.class);
            map2.put(F_DUPFD, "F_DUPFD");
            map2.put(F_GETFD, "F_GETFD");
            map2.put(F_SETFD, "F_SETFD");
            map2.put(F_GETFL, "F_GETFL");
            map2.put(F_SETFL, "F_SETFL");
            map2.put(F_GETOWN, "F_GETOWN");
            map2.put(F_SETOWN, "F_SETOWN");
            map2.put(F_GETLK, "F_GETLK");
            map2.put(F_SETLK, "F_SETLK");
            map2.put(F_SETLKW, "F_SETLKW");
            map2.put(F_RDLCK, "F_RDLCK");
            map2.put(F_UNLCK, "F_UNLCK");
            map2.put(F_WRLCK, "F_WRLCK");
            return map2;
        }
    }
}

