/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.filewatch;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;

public class WatchedFilesCollection
extends RubyObject {
    private SortedMap<IRubyObject, RubyString> files;
    private RubyHash filesInverse;
    private String sortBy;
    private static final CachingCallSite modified_at_site = new FunctionalCachingCallSite("modified_at");
    private static final CachingCallSite path_site = new FunctionalCachingCallSite("path");

    public WatchedFilesCollection(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass);
    }

    static void load(Ruby runtime) {
        runtime.getOrCreateModule("FileWatch").defineClassUnder("WatchedFilesCollection", runtime.getObject(), WatchedFilesCollection::new).defineAnnotatedMethods(WatchedFilesCollection.class);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context, IRubyObject settings) {
        Comparator comparator;
        String sort_by = settings.callMethod(context, "file_sort_by").asJavaString();
        String sort_direction = settings.callMethod(context, "file_sort_direction").asJavaString();
        switch (sort_by) {
            case "last_modified": {
                this.sortBy = "modified_at";
                comparator = (file1, file2) -> {
                    if (file1 == file2) {
                        return 0;
                    }
                    RubyFloat mtime1 = WatchedFilesCollection.modified_at(context, file1);
                    RubyFloat mtime2 = WatchedFilesCollection.modified_at(context, file2);
                    int cmp = Double.compare(mtime1.getDoubleValue(), mtime2.getDoubleValue());
                    if (cmp == 0) {
                        return WatchedFilesCollection.path(context, file1).op_cmp(WatchedFilesCollection.path(context, file2));
                    }
                    return cmp;
                };
                break;
            }
            case "path": {
                this.sortBy = "path";
                comparator = (file1, file2) -> WatchedFilesCollection.path(context, file1).op_cmp(WatchedFilesCollection.path(context, file2));
                break;
            }
            default: {
                throw context.runtime.newArgumentError("sort_by: '" + sort_by + "' not supported");
            }
        }
        switch (sort_direction) {
            case "asc": {
                break;
            }
            case "desc": {
                comparator = comparator.reversed();
                break;
            }
            default: {
                throw context.runtime.newArgumentError("sort_direction: '" + sort_direction + "' not supported");
            }
        }
        this.files = new TreeMap(comparator);
        this.filesInverse = RubyHash.newHash((Ruby)context.runtime);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject add(ThreadContext context, IRubyObject file) {
        RubyString path = WatchedFilesCollection.getFilePath(context, file);
        WatchedFilesCollection watchedFilesCollection = this;
        synchronized (watchedFilesCollection) {
            RubyString prev_path = this.files.put(file, path);
            assert (prev_path == null || path.equals((Object)prev_path));
            this.filesInverse.op_aset(context, (IRubyObject)path, file);
        }
        return path;
    }

    private static RubyString getFilePath(ThreadContext context, IRubyObject file) {
        IRubyObject path = file.callMethod(context, "path");
        if (!(path instanceof RubyString)) {
            throw context.runtime.newTypeError("expected file.path to return String but did not file: " + file.inspect());
        }
        if (!path.isFrozen()) {
            path = ((RubyString)path).dupFrozen();
        }
        return (RubyString)path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject remove_paths(ThreadContext context, IRubyObject arg) {
        IRubyObject[] paths = arg instanceof RubyArray ? ((RubyArray)arg).toJavaArray() : new IRubyObject[]{arg};
        int removedCount = 0;
        WatchedFilesCollection watchedFilesCollection = this;
        synchronized (watchedFilesCollection) {
            for (IRubyObject path : paths) {
                if (!this.removePath(context, path.convertToString())) continue;
                ++removedCount;
            }
        }
        return context.runtime.newFixnum(removedCount);
    }

    private boolean removePath(ThreadContext context, RubyString path) {
        IRubyObject file = this.filesInverse.delete(context, (IRubyObject)path, Block.NULL_BLOCK);
        if (file.isNil()) {
            return false;
        }
        return this.files.remove(file) != null;
    }

    @JRubyMethod
    public synchronized IRubyObject get(ThreadContext context, IRubyObject path) {
        return this.filesInverse.op_aref(context, path);
    }

    @JRubyMethod
    public synchronized IRubyObject size(ThreadContext context) {
        return context.runtime.newFixnum(this.files.size());
    }

    @JRubyMethod(name={"empty?"})
    public synchronized IRubyObject empty_p(ThreadContext context) {
        return context.runtime.newBoolean(this.files.isEmpty());
    }

    @JRubyMethod
    public synchronized IRubyObject each_file(ThreadContext context, Block block) {
        for (IRubyObject watched_file : this.files.keySet()) {
            block.yield(context, watched_file);
        }
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject paths(ThreadContext context) {
        IRubyObject[] values;
        WatchedFilesCollection watchedFilesCollection = this;
        synchronized (watchedFilesCollection) {
            values = (IRubyObject[])this.files.values().stream().toArray(IRubyObject[]::new);
        }
        return context.runtime.newArrayNoCopy(values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject files(ThreadContext context) {
        IRubyObject[] keys;
        WatchedFilesCollection watchedFilesCollection = this;
        synchronized (watchedFilesCollection) {
            keys = (IRubyObject[])this.files.keySet().stream().toArray(IRubyObject[]::new);
        }
        return context.runtime.newArrayNoCopy(keys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod
    public IRubyObject update(ThreadContext context, IRubyObject file) {
        if (!"modified_at".equals(this.sortBy)) {
            return context.nil;
        }
        RubyString path = WatchedFilesCollection.getFilePath(context, file);
        WatchedFilesCollection watchedFilesCollection = this;
        synchronized (watchedFilesCollection) {
            this.files.remove(file);
            WatchedFilesCollection.modified_at(context, file, context.tru);
            RubyString prev_path = this.files.put(file, path);
            assert (prev_path == null);
        }
        return context.tru;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        Ruby runtime = this.getRuntime();
        if (!(original instanceof WatchedFilesCollection)) {
            throw runtime.newTypeError("Expecting an instance of class WatchedFilesCollection");
        }
        WatchedFilesCollection proto = (WatchedFilesCollection)original;
        this.files = new TreeMap<IRubyObject, RubyString>(proto.files.comparator());
        WatchedFilesCollection watchedFilesCollection = proto;
        synchronized (watchedFilesCollection) {
            this.files.putAll(proto.files);
            this.filesInverse = (RubyHash)proto.filesInverse.dup(runtime.getCurrentContext());
        }
        return this;
    }

    public IRubyObject inspect() {
        return this.getRuntime().newString("#<" + this.metaClass.getRealClass().getName() + ": size=" + this.files.size() + ">");
    }

    private static RubyString path(ThreadContext context, IRubyObject watched_file) {
        return path_site.call(context, watched_file, watched_file).convertToString();
    }

    private static RubyFloat modified_at(ThreadContext context, IRubyObject watched_file) {
        return modified_at_site.call(context, watched_file, watched_file).convertToFloat();
    }

    private static RubyFloat modified_at(ThreadContext context, IRubyObject watched_file, RubyBoolean update) {
        return modified_at_site.call(context, watched_file, watched_file, (IRubyObject)update).convertToFloat();
    }
}

