/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.compiler;

import co.elastic.logstash.api.Codec;
import co.elastic.logstash.api.Context;
import co.elastic.logstash.api.CounterMetric;
import co.elastic.logstash.api.Event;
import co.elastic.logstash.api.Metric;
import co.elastic.logstash.api.NamespacedMetric;
import co.elastic.logstash.api.PluginConfigSpec;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.logstash.instrument.metrics.MetricKeys;

public class JavaCodecDelegator
implements Codec {
    public static final String ENCODE_KEY = "encode";
    public static final String DECODE_KEY = "decode";
    public static final String IN_KEY = "writes_in";
    private final Codec codec;
    protected final CounterMetric encodeMetricIn;
    protected final CounterMetric encodeMetricTime;
    protected final CounterMetric decodeMetricIn;
    protected final CounterMetric decodeMetricOut;
    protected final CounterMetric decodeMetricTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaCodecDelegator(Context context, Codec codec) {
        this.codec = codec;
        NamespacedMetric metric = context.getMetric(codec);
        Metric metric2 = metric.root();
        synchronized (metric2) {
            metric.gauge(MetricKeys.NAME_KEY.asJavaString(), codec.getName());
            NamespacedMetric encodeMetric = metric.namespace(ENCODE_KEY);
            this.encodeMetricIn = encodeMetric.counter(IN_KEY);
            this.encodeMetricTime = encodeMetric.counter(MetricKeys.DURATION_IN_MILLIS_KEY.asJavaString());
            NamespacedMetric decodeMetric = metric.namespace(DECODE_KEY);
            this.decodeMetricIn = decodeMetric.counter(IN_KEY);
            this.decodeMetricOut = decodeMetric.counter(MetricKeys.OUT_KEY.asJavaString());
            this.decodeMetricTime = decodeMetric.counter(MetricKeys.DURATION_IN_MILLIS_KEY.asJavaString());
        }
    }

    @Override
    public void decode(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        this.decodeMetricIn.increment();
        long start = System.nanoTime();
        this.codec.decode(buffer, event -> {
            this.decodeMetricOut.increment();
            eventConsumer.accept((Map<String, Object>)event);
        });
        this.decodeMetricTime.increment(TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
    }

    @Override
    public void flush(ByteBuffer buffer, Consumer<Map<String, Object>> eventConsumer) {
        this.decodeMetricIn.increment();
        long start = System.nanoTime();
        this.codec.flush(buffer, event -> {
            this.decodeMetricOut.increment();
            eventConsumer.accept((Map<String, Object>)event);
        });
        this.decodeMetricTime.increment(TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
    }

    @Override
    public void encode(Event event, OutputStream out) throws IOException {
        this.encodeMetricIn.increment();
        long start = System.nanoTime();
        this.codec.encode(event, out);
        this.decodeMetricTime.increment(TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
    }

    @Override
    public Codec cloneCodec() {
        return this.codec.cloneCodec();
    }

    @Override
    public Collection<PluginConfigSpec<?>> configSchema() {
        return this.codec.configSchema();
    }

    @Override
    public String getName() {
        return this.codec.getName();
    }

    @Override
    public String getId() {
        return this.codec.getId();
    }
}

