/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.inputs.http.util;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.plugins.inputs.http.util.SslSimpleBuilder;

public class SslHandlerProvider {
    private static final Logger logger = LogManager.getLogger(SslSimpleBuilder.class);
    private final SslContext sslContext;
    private SslClientVerifyMode verifyMode = SslClientVerifyMode.NONE;
    private long handshakeTimeoutMilliseconds = 10000L;
    private String[] protocols = new String[]{"TLSv1.2"};

    public SslHandlerProvider(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public SslHandler getSslHandler(ByteBufAllocator bufferAllocator) {
        SslHandler sslHandler = this.sslContext.newHandler(bufferAllocator);
        SSLEngine engine = sslHandler.engine();
        engine.setEnabledProtocols(this.protocols);
        engine.setUseClientMode(false);
        if (this.verifyMode == SslClientVerifyMode.FORCE_PEER) {
            engine.setNeedClientAuth(true);
        } else if (this.verifyMode == SslClientVerifyMode.VERIFY_PEER) {
            engine.setWantClientAuth(true);
        }
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMilliseconds);
        return sslHandler;
    }

    public void setVerifyMode(String verifyMode) {
        if (verifyMode.equals("FORCE_PEER")) {
            this.verifyMode = SslClientVerifyMode.FORCE_PEER;
        } else if (verifyMode.equals("PEER")) {
            this.verifyMode = SslClientVerifyMode.VERIFY_PEER;
        }
    }

    public void setProtocols(String[] protocols) {
        if (logger.isDebugEnabled()) {
            logger.debug("TLS: " + Arrays.toString(protocols));
        }
        this.protocols = protocols;
    }

    public void setHandshakeTimeoutMilliseconds(long handshakeTimeoutMilliseconds) {
        this.handshakeTimeoutMilliseconds = handshakeTimeoutMilliseconds;
    }

    static enum SslClientVerifyMode {
        VERIFY_PEER,
        FORCE_PEER,
        NONE;

    }
}

