/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.opto.ConstantCache;
import org.jruby.runtime.opto.Invalidator;

public class SearchConstInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final RubySymbol constantName;
    private final boolean noPrivateConsts;
    private volatile transient ConstantCache cache;

    public SearchConstInstr(Variable result2, RubySymbol constantName, Operand startingScope, boolean noPrivateConsts) {
        super(Operation.SEARCH_CONST, result2, startingScope);
        assert (result2 != null) : "SearchConstInstr result is null";
        this.constantName = constantName;
        this.noPrivateConsts = noPrivateConsts;
    }

    public Operand getStartingScope() {
        return this.getOperand1();
    }

    public String getId() {
        return this.constantName.idString();
    }

    public RubySymbol getName() {
        return this.constantName;
    }

    public boolean isNoPrivateConsts() {
        return this.noPrivateConsts;
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new SearchConstInstr(ii.getRenamedVariable(this.result), this.constantName, this.getStartingScope().cloneForInlining(ii), this.noPrivateConsts);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getName());
        e.encode(this.getStartingScope());
        e.encode(this.isNoPrivateConsts());
    }

    public static SearchConstInstr decode(IRReaderDecoder d) {
        return new SearchConstInstr(d.decodeVariable(), d.decodeSymbol(), d.decodeOperand(), d.decodeBoolean());
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"name: " + this.getName(), "no_priv: " + this.noPrivateConsts};
    }

    public ConstantCache getConstantCache() {
        return this.cache;
    }

    public Object cache(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Ruby runtime2 = context.getRuntime();
        RubyClass object = runtime2.getObject();
        String id2 = this.getId();
        StaticScope staticScope = (StaticScope)this.getStartingScope().retrieve(context, self2, currScope, currDynScope, temp);
        IRubyObject constant = staticScope == null ? object.getConstant(id2) : staticScope.getConstantInner(id2);
        RubyModule module = null;
        if (constant == null) {
            module = staticScope == null ? object : staticScope.getModule();
            IRubyObject iRubyObject = constant = this.noPrivateConsts ? module.getConstantFromNoConstMissing(id2, false) : module.getConstantNoConstMissing(id2);
        }
        if (constant == null) {
            constant = module.callMethod(context, "const_missing", (IRubyObject)runtime2.fastNewSymbol(id2));
        } else {
            Invalidator invalidator = runtime2.getConstantInvalidator(id2);
            this.cache = new ConstantCache(constant, invalidator.getData(), invalidator);
        }
        return constant;
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        ConstantCache cache = this.cache;
        if (!ConstantCache.isCached(cache)) {
            return this.cache(context, currScope, currDynScope, self2, temp);
        }
        return cache.value;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.SearchConstInstr(this);
    }
}

