/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventprocessorhost;

import com.microsoft.azure.eventhubs.EventData;
import com.microsoft.azure.eventhubs.EventPosition;
import com.microsoft.azure.eventhubs.ReceiverRuntimeInformation;
import com.microsoft.azure.eventprocessorhost.Checkpoint;
import com.microsoft.azure.eventprocessorhost.CompleteLease;
import com.microsoft.azure.eventprocessorhost.HostContext;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionContext {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(PartitionContext.class);
    private final HostContext hostContext;
    private final String partitionId;
    private CompleteLease lease;
    private String offset = null;
    private long sequenceNumber = 0L;
    private ReceiverRuntimeInformation runtimeInformation;

    PartitionContext(HostContext hostContext, String partitionId) {
        this.hostContext = hostContext;
        this.partitionId = partitionId;
        this.runtimeInformation = new ReceiverRuntimeInformation(partitionId);
    }

    public String getConsumerGroupName() {
        return this.hostContext.getConsumerGroupName();
    }

    public String getEventHubPath() {
        return this.hostContext.getEventHubPath();
    }

    public String getOwner() {
        return this.lease.getOwner();
    }

    public ReceiverRuntimeInformation getRuntimeInformation() {
        return this.runtimeInformation;
    }

    void setRuntimeInformation(ReceiverRuntimeInformation value) {
        this.runtimeInformation = value;
    }

    CompleteLease getLease() {
        return this.lease;
    }

    void setLease(CompleteLease lease) {
        this.lease = lease;
    }

    void setOffsetAndSequenceNumber(EventData event) {
        if (event.getSystemProperties().getSequenceNumber() >= this.sequenceNumber) {
            this.offset = event.getSystemProperties().getOffset();
            this.sequenceNumber = event.getSystemProperties().getSequenceNumber();
        } else {
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionId, "setOffsetAndSequenceNumber(" + event.getSystemProperties().getOffset() + "//" + event.getSystemProperties().getSequenceNumber() + ") would move backwards, ignoring"));
        }
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    CompletableFuture<EventPosition> getInitialOffset() {
        return this.hostContext.getCheckpointManager().getCheckpoint(this.partitionId).thenApply(startingCheckpoint -> this.checkpointToOffset((Checkpoint)startingCheckpoint));
    }

    EventPosition checkpointToOffset(Checkpoint startingCheckpoint) {
        EventPosition startAt = null;
        if (startingCheckpoint == null) {
            Function<String, EventPosition> initialPositionProvider = this.hostContext.getEventProcessorOptions().getInitialPositionProvider();
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(this.partitionId, "Calling user-provided initial position provider"));
            startAt = initialPositionProvider.apply(this.partitionId);
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionId, "Initial position provided: " + startAt));
        } else {
            this.offset = startingCheckpoint.getOffset();
            startAt = EventPosition.fromOffset((String)this.offset);
            this.sequenceNumber = startingCheckpoint.getSequenceNumber();
            TRACE_LOGGER.info(this.hostContext.withHostAndPartition(this.partitionId, "Retrieved starting offset " + this.offset + "//" + this.sequenceNumber));
        }
        return startAt;
    }

    public CompletableFuture<Void> checkpoint() {
        CompletableFuture<Void> result = null;
        if (this.offset == null) {
            result = new CompletableFuture<Void>();
            result.completeExceptionally(new RuntimeException("Cannot checkpoint until at least one event has been received on this partition"));
        } else {
            Checkpoint capturedCheckpoint = new Checkpoint(this.partitionId, this.offset, this.sequenceNumber);
            result = this.checkpoint(capturedCheckpoint);
        }
        return result;
    }

    public CompletableFuture<Void> checkpoint(EventData event) {
        CompletableFuture<Void> result = null;
        if (event == null) {
            result = new CompletableFuture<Void>();
            result.completeExceptionally(new IllegalArgumentException("Cannot checkpoint with null EventData"));
        } else {
            result = this.checkpoint(new Checkpoint(this.partitionId, event.getSystemProperties().getOffset(), event.getSystemProperties().getSequenceNumber()));
        }
        return result;
    }

    public CompletableFuture<Void> checkpoint(Checkpoint checkpoint) {
        CompletableFuture<Void> result = null;
        if (checkpoint == null) {
            result = new CompletableFuture<Void>();
            result.completeExceptionally(new IllegalArgumentException("Cannot checkpoint with null Checkpoint"));
        } else {
            TRACE_LOGGER.debug(this.hostContext.withHostAndPartition(checkpoint.getPartitionId(), "Saving checkpoint: " + checkpoint.getOffset() + "//" + checkpoint.getSequenceNumber()));
            result = this.hostContext.getCheckpointManager().updateCheckpoint(this.lease, checkpoint);
        }
        return result;
    }
}

