import { DataStore } from "../datastore/DataStore";
import { IrcClientConfig } from "../models/IrcClientConfig";
import { IrcServer } from "./IrcServer";
export declare class Ipv6Generator {
    private readonly dataStore;
    private counter;
    private queue;
    constructor(dataStore: DataStore);
    getCounterKey(userId: string | null, server: IrcServer): string;
    /**
     * Generate a new IPv6 address for the given IRC client config.
     * @param {string} prefix The IPv6 prefix to use.
     * @param {IrcClientConfig} ircClientConfig The config to set the address on.
     * @return {Promise} Resolves to the IPv6 address generated; the IPv6 address will
     * already be set on the given config.
     */
    generate(prefix: string, ircClientConfig: IrcClientConfig, server: IrcServer): Promise<string>;
    process(prefix: string, ircClientConfig: IrcClientConfig, server: IrcServer): Promise<string | undefined>;
}
