import { MatrixClient } from "../MatrixClient";
import { EncryptionEventContent } from "../models/events/EncryptionEvent";
/**
 * Tracks room encryption status for a MatrixClient.
 * @category Encryption
 */
export declare class RoomTracker {
    private client;
    constructor(client: MatrixClient);
    /**
     * Prepares the room tracker to track the given rooms.
     * @param {string[]} roomIds The room IDs to track. This should be the joined rooms set.
     */
    prepare(roomIds: string[]): Promise<void>;
    /**
     * Queues a room check for the tracker. If the room needs an update to the store, an
     * update will be made.
     * @param {string} roomId The room ID to check.
     */
    queueRoomCheck(roomId: string): Promise<void>;
    /**
     * Gets the room's crypto configuration, as known by the underlying store. If the room is
     * not encrypted then this will return an empty object.
     * @param {string} roomId The room ID to get the config for.
     * @returns {Promise<Partial<EncryptionEventContent>>} Resolves to the encryption config.
     */
    getRoomCryptoConfig(roomId: string): Promise<Partial<EncryptionEventContent>>;
}
