# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.multi_block_data_set_algorithm import MultiBlockDataSetAlgorithm


class AMReXParticlesReader(MultiBlockDataSetAlgorithm):
    """
    AMReXParticlesReader - reader for am_re_x plotfiles particle data.
    
    Superclass: MultiBlockDataSetAlgorithm
    
    AMReXParticlesReader readers particle data from am_re_x plotfiles.
    The reader is based on the  `_particle_container::_restart` and
    `amrex_binary_particles_to_vtp` files in the [_am_re_x
    code](https://amrex-codes.github.io/).
    
    The reader reads all levels in as blocks in output multiblock dataset
    distributed datasets at each level between ranks in a contiguous
    fashion.
    
    To use the reader, one must set the `_plot_file_name` and `_particle_type`
    which identifies the type particles from the plot_file_name to read.
    
    The reader provides ability to select point data arrays to be made
    available in the output. Note that due to the nature of the file
    structure, all variables are still read in and hence deselecting
    arrays does not reduce I/O calls or initial memory requirements.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAMReXParticlesReader, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Get/Set the controller to use. By default, the global
        MultiProcessController will be used.
        """
    )

    particle_type = traits.String('particles', enter_set=True, auto_set=False, desc=\
        """
        Get/Set the particle type to read. By default, this is set to
        'particles'.
        """
    )

    def _particle_type_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetParticleType,
                        self.particle_type)

    plot_file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Get/Set the am_re_x plotfile. Note this is a directory on the
        filesystem and not the file.
        """
    )

    def _plot_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPlotFileName,
                        self.plot_file_name)

    def _get_point_data_array_selection(self):
        return wrap_vtk(self._vtk_obj.GetPointDataArraySelection())
    point_data_array_selection = traits.Property(_get_point_data_array_selection, desc=\
        """
        Get DataArraySelection instance to select point arrays to
        read. Due to the nature of the am_re_x particles files, all point
        data is read in from the disk, despite certain arrays unselected.
        The unselected arrays will be discarded from the generated output
        dataset.
        """
    )

    def can_read_file(self, *args):
        """
        V.can_read_file(string, string) -> int
        C++: static int CanReadFile(const char *fname,
            const char *particlesType=nullptr)
        Returns 1 is fname refers to a plotfile that the reader can read.
        """
        ret = self._wrap_call(self._vtk_obj.CanReadFile, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('particle_type', 'GetParticleType'), ('plot_file_name',
    'GetPlotFileName'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'particle_type', 'plot_file_name',
    'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AMReXParticlesReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AMReXParticlesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['particle_type', 'plot_file_name']),
            title='Edit AMReXParticlesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AMReXParticlesReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

