# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.directed_graph_algorithm import DirectedGraphAlgorithm


class ReebGraphSimplificationFilter(DirectedGraphAlgorithm):
    """
    ReebGraphSimplificationFilter - simplify an input Reeb graph.
    
    Superclass: DirectedGraphAlgorithm
    
    The filter takes an input ReebGraph object and outputs a
    ReebGraph object.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkReebGraphSimplificationFilter, obj, update, **traits)
    
    simplification_threshold = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        """
        Set the persistence threshold for simplification (from 0 to 1).
        Default value: 0 (no simplification).
        """
    )

    def _simplification_threshold_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSimplificationThreshold,
                        self.simplification_threshold)

    def set_simplification_metric(self, *args):
        """
        V.set_simplification_metric(ReebGraphSimplificationMetric)
        C++: void SetSimplificationMetric(
            ReebGraphSimplificationMetric *metric)
        Set the persistence metric evaluation code Default value: nullptr
        (standard topological persistence).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSimplificationMetric, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('simplification_threshold', 'GetSimplificationThreshold'),
    ('progress', 'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text', 'simplification_threshold'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ReebGraphSimplificationFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ReebGraphSimplificationFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['simplification_threshold']),
            title='Edit ReebGraphSimplificationFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ReebGraphSimplificationFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

