# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class Voronoi2D(PolyDataAlgorithm):
    """
    Voronoi2D - create 2d Voronoi convex tiling of input points
    
    Superclass: PolyDataAlgorithm
    
    Voronoi2D is a filter that constructs a 2d Voronoi tessellation of
    a list of input points. The points are assumed to lie in a plane.
    These points may be represented by any dataset of type PointSet
    and subclasses. The output of the filter is a polygonal dataset. Each
    output cell is a convex polygon.
    
    The 2d Voronoi tessellation is a tiling of space, where each Voronoi
    tile represents the region nearest to one of the input points.
    Voronoi tessellations are important in computational geometry (and
    many other fields), and are the dual of Delaunay triangulations.
    
    The input to this filter is a list of points specified in 3d, even
    though the triangulation is 2d. Thus the triangulation is constructed
    in the x-y plane, and the z coordinate is ignored (although carried
    through to the output). If you desire to triangulate in a different
    plane, you can use the TransformFilter to transform the points
    into and out of the x-y plane or you can specify a transform to
    Voronoi2D directly.  In the latter case, the input points are
    transformed, the transformed points are triangulated, and the output
    will use the triangulated topology for the original (non-transformed)
    points.  This avoids transforming the data back as would be required
    when using the TransformFilter method.  Specifying a transform
    directly also allows any transform to be used: rigid, non-rigid,
    non-invertible, etc.
    
    This filter is a reference implementation written with simplicity in
    mind. Additional methods are available for debugging / instructional
    purposes. This includes producing a single tile under various stages
    of creation, as well as the Voronoi flower, related to the error
    metric for point insertion / half-space clipping.
    
    Publications are in preparation to describe the algorithm. A brief
    summary is as follows. In parallel, each (generating) input point is
    associated with an initial Voronoi tile, which is simply the bounding
    box of the point set. A locator is then used to identify nearby
    points: each neighbor in turn generates a clipping line positioned
    halfway between the generating point and the neigboring point, and
    orthogonal to the line connecting them. Clips are readily performed
    by evaluationg the vertices of the convex Voronoi tile as being on
    either side (inside,outside) of the clip line. If two intersections
    of the Voronoi tile are found, the portion of the tile "outside" the
    clip line is discarded, resulting in a new convex, Voronoi tile. As
    each clip occurs, the Voronoi "Flower" error metric (the union of
    error spheres) is compared to the extent of the region containing the
    neighboring clip points. The clip region (along with the points
    contained in it) is grown by careful expansion (e.g., outward
    spiraling iterator over all candidate clip points). When the Voronoi
    Flower is contained within the clip region, the algorithm terminates
    and the Voronoi tile is output. Once complete, it is possible to
    construct the Delaunay triangulation from the Voronoi tessellation.
    Note that topological and geometric information is used to generate a
    valid triangulation (e.g., merging points and validating topology).
    
    @warning
    Coincident input points will result in overlapping tiles.  This is
    because the Voronoi tessellation requires unique input points.
    
    @warning
    This is a novel approach which implements an embarrasingly parallel
    algorithm. At the core of the algorithm a locator is used to
    determine points close to a specified position. A
    StaticPointLocator2D is used because it is both threaded (when
    constructed) and supports thread-safe queries. While other locators
    could be used in principal, they must support thread-safe operations.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    @sa
    Delaunay2D TransformFilter StaticPointLocator2D
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkVoronoi2D, obj, update, **traits)
    
    generate_voronoi_flower = tvtk_base.false_bool_trait(desc=\
        """
        These methods are for debugging or instructional purposes. If
        generate_voronoi_flower is on, and the point_of_intersect is
        specified, then second and third (optional) outputs are populated
        which contains a representation of the Voronoi flower error
        metric (second output) and the single Voronoi tile (corresponding
        to point_of_interest) with point scalar values indicating the radii
        of the Voronoi Flower petals (i.e., circles contributing to the
        error metric).
        """
    )

    def _generate_voronoi_flower_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateVoronoiFlower,
                        self.generate_voronoi_flower_)

    generate_scalars = traits.Trait('none',
    tvtk_base.TraitRevPrefixMap({'none': 0, 'point_ids': 1, 'thread_ids': 2}), desc=\
        """
        Indicate whether to create a scalar array as part of the output.
        No scalars; point ids, or execution thread ids may be output. By
        default no scalars are generated.
        """
    )

    def _generate_scalars_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetGenerateScalars,
                        self.generate_scalars_)

    projection_plane_mode = traits.Trait('xy_plane',
    tvtk_base.TraitRevPrefixMap({'xy_plane': 0, 'best_fitting_plane': 2, 'specified_transform_plane': 1}), desc=\
        """
        Define the method to project the input 3d points into a 2d plane
        for tessellation. When the VTK_XY_PLANE is set, the z-coordinate
        is simply ignored. When VTK_SET_TRANSFORM_PLANE is set, then a
        transform must be supplied and the points are transformed using
        it. Finally, if VTK_BEST_FITTING_PLANE is set, then the filter
        computes a best fitting plane and projects the points onto it.
        """
    )

    def _projection_plane_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProjectionPlaneMode,
                        self.projection_plane_mode_)

    maximum_number_of_tile_clips = traits.Trait(2147483647, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        These methods are for debugging or instructional purposes. When
        the point of interest is specified (i.e., to a non-negative
        number) then the algorithm will only process this single point
        (whose id is the point_of_interest). The maximum number of clips
        (the maximum_number_of_tile_clips) can be specified. If
        maximum_number_of_tile_clips=_0, then the initial tile (single point
        within the bounding box) is produced; if =1 then the split with
        the closest point is produced; and so on. By default the
        point_of_interest is set to (-1), and the number of clips is
        unlimited (i.e., maximum_number_of_tile_clips=_vtk__id__max and
        therefore automatically limited by the algorithm).
        """
    )

    def _maximum_number_of_tile_clips_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMaximumNumberOfTileClips,
                        self.maximum_number_of_tile_clips)

    padding = traits.Trait(0.01, traits.Range(0.001, 0.25, enter_set=True, auto_set=False), desc=\
        """
        Specify a padding for the bounding box of the points. A >0
        padding is necessary in order to create valid Voronoi tiles on
        the boundary of the tessellation. The padding is specified as a
        fraction of the diagonal length of the bounding box of the
        points.
        """
    )

    def _padding_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPadding,
                        self.padding)

    point_of_interest = traits.Trait(-1, traits.Range(-1, 2147483647, enter_set=True, auto_set=False), desc=\
        """
        These methods are for debugging or instructional purposes. When
        the point of interest is specified (i.e., to a non-negative
        number) then the algorithm will only process this single point
        (whose id is the point_of_interest). The maximum number of clips
        (the maximum_number_of_tile_clips) can be specified. If
        maximum_number_of_tile_clips=_0, then the initial tile (single point
        within the bounding box) is produced; if =1 then the split with
        the closest point is produced; and so on. By default the
        point_of_interest is set to (-1), and the number of clips is
        unlimited (i.e., maximum_number_of_tile_clips=_vtk__id__max and
        therefore automatically limited by the algorithm).
        """
    )

    def _point_of_interest_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPointOfInterest,
                        self.point_of_interest)

    def _get_transform(self):
        return wrap_vtk(self._vtk_obj.GetTransform())
    def _set_transform(self, arg):
        old_val = self._get_transform()
        self._wrap_call(self._vtk_obj.SetTransform,
                        deref_vtk(arg))
        self.trait_property_changed('transform', old_val, arg)
    transform = traits.Property(_get_transform, _set_transform, desc=\
        """
        Set / get the transform which is applied to points to generate a
        2d problem.  This maps a 3d dataset into a 2d dataset where
        triangulation can be done on the XY plane.  The points are then
        tessellated and the topology of tessellation are used as the
        output topology.  The output points are the original
        (untransformed) points.  The transform can be any subclass of
        AbstractTransform (thus it does not need to be a linear or
        invertible transform).
        """
    )

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def _get_locator(self):
        return wrap_vtk(self._vtk_obj.GetLocator())
    locator = traits.Property(_get_locator, desc=\
        """
        Retrieve the internal locator to manually configure it, for
        example specifying the number of points per bucket. This method
        is generally used for debugging or testing purposes.
        """
    )

    def _get_number_of_threads_used(self):
        return self._vtk_obj.GetNumberOfThreadsUsed()
    number_of_threads_used = traits.Property(_get_number_of_threads_used, desc=\
        """
        Return the number of threads actually used during execution. This
        is valid only after algorithm execution.
        """
    )

    def _get_spheres(self):
        return wrap_vtk(self._vtk_obj.GetSpheres())
    spheres = traits.Property(_get_spheres, desc=\
        """
        Return the Voronoi flower (a collection of spheres) for the point
        of interest in the form of a Spheres implicit function. This
        is valid only if generate_voronoi_flower and the point_of_interest
        are set, and after the filter executes. Typically this is used
        for debugging or educational purposes.
        """
    )

    _updateable_traits_ = \
    (('generate_voronoi_flower', 'GetGenerateVoronoiFlower'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('generate_scalars', 'GetGenerateScalars'), ('projection_plane_mode',
    'GetProjectionPlaneMode'), ('maximum_number_of_tile_clips',
    'GetMaximumNumberOfTileClips'), ('padding', 'GetPadding'),
    ('point_of_interest', 'GetPointOfInterest'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'generate_voronoi_flower',
    'global_warning_display', 'release_data_flag', 'generate_scalars',
    'projection_plane_mode', 'maximum_number_of_tile_clips', 'padding',
    'point_of_interest', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Voronoi2D, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Voronoi2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['generate_voronoi_flower'], ['generate_scalars',
            'projection_plane_mode'], ['maximum_number_of_tile_clips', 'padding',
            'point_of_interest']),
            title='Edit Voronoi2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Voronoi2D properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

