# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.table_algorithm import TableAlgorithm


class BoostSplitTableField(TableAlgorithm):
    """
    BoostSplitTableField - "Splits" one-or-more table fields by
    duplicating rows containing delimited data.
    
    Superclass: TableAlgorithm
    
    Assume the following table:
    
    Author                Year     Title Brian; Jeff; Tim      2007    
    Foo Tim                   2003     Bar
    
    If we produce a graph relating authors to the year in which they
    publish, the string "Brian; Jeff; Tim" will be treated (incorrectly)
    as a single author associated with the year 2007. 
    BoostSplitTableField addresses this by splitting one-or-more
    fields into "subvalues" using a configurable delimiter and placing
    each subvalue on its own row (the other fields in the original row
    are copied).  Using the above example, splitting the "Author" field
    with a ";" (semicolon) delimiter produces:
    
    Author                Year     Title Brian                 2007    
    Foo Jeff                  2007     Foo Tim                   2007    
    Foo Tim                   2003     Bar
    
    When this table is converted to a graph, each author (correctly)
    becomes a separate node.
    
    Usage:
    
    Use add_field() to specify the field(s) to be split.  If no fields
    have been specified, BoostSplitTableField will act as a
    passthrough.  By default, no fields are specified.
    
    The second argument to add_field() is a string containing zero-to-many
    single character delimiters (multi-character delimiters are not
    supported).
    
    If the input table is missing a field specified by add_field(), it is
    an error. If no fields are specified, no splitting is performed. If
    the delimiter for a field is an empty string, no splitting is
    performed on that field.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkBoostSplitTableField, obj, update, **traits)
    
    def add_field(self, *args):
        """
        V.add_field(string, string)
        C++: void AddField(const char *field, const char *delimiters)"""
        ret = self._wrap_call(self._vtk_obj.AddField, *args)
        return ret

    def clear_fields(self):
        """
        V.clear_fields()
        C++: void ClearFields()"""
        ret = self._vtk_obj.ClearFields()
        return ret
        

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(BoostSplitTableField, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit BoostSplitTableField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], []),
            title='Edit BoostSplitTableField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit BoostSplitTableField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

