# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.exodus_ii_reader import ExodusIIReader


class PExodusIIReader(ExodusIIReader):
    """
    PExodusIIReader - Read Exodus II files (.exii)
    
    Superclass: ExodusIIReader
    
    PExodusIIReader is a unstructured grid source object that reads
    exodus_ii files. Most of the meta data associated with the file is
    loaded when update_information is called. This includes information
    like Title, number of blocks, number and names of arrays. This data
    can be retrieved from methods in this reader. Separate arrays that
    are meant to be a single vector, are combined internally for
    convenience. To be combined, the array names have to be identical
    except for a trailing X,Y and Z (or x,y,z). By default all cell and
    point arrays are loaded. However, the user can flag arrays not to
    load with the methods "_set_point_data_array_load_flag" and
    "_set_cell_data_array_load_flag". The reader responds to piece requests by
    loading only a range of the possible blocks. Unused points are
    filtered out internally.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPExodusIIReader, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Set/get the communication object used to relay a list of files
        from the rank 0 process to all others. This is the only
        interprocess communication required by PExodusIIReader.
        """
    )

    file_name = tvtk_base.vtk_file_name("", desc=\
        """
        Specify file name of the Exodus file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    file_pattern = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        """
        These methods tell the reader that the data is distributed across
        multiple files. This is for distributed execution. It this case,
        pieces are mapped to files. The pattern should have one %d to
        format the file number. file_number_range is used to generate file
        numbers. I was thinking of having an arbitrary list of file
        numbers. This may happen in the future. (That is why there is no
        get_file_number_range method.
        """
    )

    def _file_pattern_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFilePattern,
                        self.file_pattern)

    file_prefix = tvtk_base.vtk_file_prefix("", desc=\
        """
        These methods tell the reader that the data is distributed across
        multiple files. This is for distributed execution. It this case,
        pieces are mapped to files. The pattern should have one %d to
        format the file number. file_number_range is used to generate file
        numbers. I was thinking of having an arbitrary list of file
        numbers. This may happen in the future. (That is why there is no
        get_file_number_range method.
        """
    )

    def _file_prefix_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFilePrefix,
                        self.file_prefix)

    file_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="int", value=(-1, -1), cols=2, desc=\
        """
        Set the range of files that are being loaded. The range for
        single file should add to 0.
        """
    )

    def _file_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileRange,
                        self.file_range)

    variable_cache_size = traits.Float(100.0, enter_set=True, auto_set=False, desc=\
        """
        The size of the variable cache in mega_byes. This represents the
        maximum size of cache that a single partition reader can have
        while reading. When a reader is finished its cache size will be
        set to a fraction of this based on the number of partitions. The
        Default for this is 100_mi_b. Note that because each reader still
        holds a fraction of the cache size after reading the total amount
        of data cached can be at most twice this size.
        """
    )

    def _variable_cache_size_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetVariableCacheSize,
                        self.variable_cache_size)

    def _get_number_of_file_names(self):
        return self._vtk_obj.GetNumberOfFileNames()
    number_of_file_names = traits.Property(_get_number_of_file_names, desc=\
        """
        Return number of file names set in set_file_names
        """
    )

    def _get_number_of_files(self):
        return self._vtk_obj.GetNumberOfFiles()
    number_of_files = traits.Property(_get_number_of_files, desc=\
        """
        Return the number of files to be read.
        """
    )

    def broadcast(self, *args):
        """
        V.broadcast(MultiProcessController)
        C++: virtual void Broadcast(MultiProcessController *ctrl)
        Sends metadata (that read from the input file, not settings
        modified through this API) from the rank 0 node to all other
        processes in a job.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Broadcast, *my_args)
        return ret

    _updateable_traits_ = \
    (('animate_mode_shapes', 'GetAnimateModeShapes'),
    ('apply_displacements', 'GetApplyDisplacements'),
    ('generate_file_id_array', 'GetGenerateFileIdArray'),
    ('generate_global_element_id_array',
    'GetGenerateGlobalElementIdArray'), ('generate_global_node_id_array',
    'GetGenerateGlobalNodeIdArray'),
    ('generate_implicit_element_id_array',
    'GetGenerateImplicitElementIdArray'),
    ('generate_implicit_node_id_array', 'GetGenerateImplicitNodeIdArray'),
    ('generate_object_id_cell_array', 'GetGenerateObjectIdCellArray'),
    ('has_mode_shapes', 'GetHasModeShapes'), ('ignore_file_time',
    'GetIgnoreFileTime'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('file_name',
    'GetFileName'), ('file_pattern', 'GetFilePattern'), ('file_prefix',
    'GetFilePrefix'), ('file_range', 'GetFileRange'),
    ('variable_cache_size', 'GetVariableCacheSize'), ('cache_size',
    'GetCacheSize'), ('displacement_magnitude',
    'GetDisplacementMagnitude'), ('display_type', 'GetDisplayType'),
    ('file_id', 'GetFileId'), ('mode_shape_time', 'GetModeShapeTime'),
    ('squeeze_points', 'GetSqueezePoints'), ('time_step', 'GetTimeStep'),
    ('xml_file_name', 'GetXMLFileName'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'animate_mode_shapes', 'apply_displacements',
    'debug', 'generate_file_id_array', 'generate_global_element_id_array',
    'generate_global_node_id_array', 'generate_implicit_element_id_array',
    'generate_implicit_node_id_array', 'generate_object_id_cell_array',
    'global_warning_display', 'has_mode_shapes', 'ignore_file_time',
    'release_data_flag', 'cache_size', 'displacement_magnitude',
    'display_type', 'file_id', 'file_name', 'file_pattern', 'file_prefix',
    'file_range', 'mode_shape_time', 'progress_text', 'squeeze_points',
    'time_step', 'variable_cache_size', 'xml_file_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PExodusIIReader, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PExodusIIReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['animate_mode_shapes', 'apply_displacements',
            'generate_file_id_array', 'generate_global_element_id_array',
            'generate_global_node_id_array', 'generate_implicit_element_id_array',
            'generate_implicit_node_id_array', 'generate_object_id_cell_array',
            'has_mode_shapes', 'ignore_file_time'], [], ['cache_size',
            'displacement_magnitude', 'display_type', 'file_id', 'file_name',
            'file_pattern', 'file_prefix', 'file_range', 'mode_shape_time',
            'squeeze_points', 'time_step', 'variable_cache_size',
            'xml_file_name']),
            title='Edit PExodusIIReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PExodusIIReader properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

