# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.structured_grid_connectivity import StructuredGridConnectivity


class PStructuredGridConnectivity(StructuredGridConnectivity):
    """
    PStructuredGridConnectivity -  PStructuredGridConnectivity
    inherits from StructuredGridConnectivity
     and implements functionality to compute the neighboring topology
    within a
     single, partitioned and distributed structured grid dataset.
    
    Superclass: StructuredGridConnectivity
    
    @warning
     Initialize(), compute_neighbors() and create_ghost_layers() are
    collective
     operations, every process must call that method.
    
    @sa
     StructuredGridConnectivity
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkPStructuredGridConnectivity, obj, update, **traits)
    
    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Set & Get the process controller
        """
    )

    number_of_grids = traits.Int(0, enter_set=True, auto_set=False, desc=\
        """
        Sets the total number of domains distributed among processors
        """
    )

    def _number_of_grids_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfGrids,
                        self.number_of_grids)

    def get_grid_rank(self, *args):
        """
        V.get_grid_rank(int) -> int
        C++: int GetGridRank(const int gridID)
        Returns the rank of the given grid_id. A nominal value of -1 for
        the return value of this method indicates that possibly
        compute_neighbors has not been called and consequently the
        grid_ranks vector has not been populated yet.
        """
        ret = self._wrap_call(self._vtk_obj.GetGridRank, *args)
        return ret

    def _get_number_of_local_grids(self):
        return self._vtk_obj.GetNumberOfLocalGrids()
    number_of_local_grids = traits.Property(_get_number_of_local_grids, desc=\
        """
        Returns the number of local grids registers by the process that
        owns the current PStructuredGridConnectivity instance
        """
    )

    def initialize(self):
        """
        V.initialize()
        C++: void Initialize()
        Initializes this instance of PStructuredGridConnectivity,
        essentially, the acquires the local process ID from the
        registered controller. If a controller is not registered, the
        global controller is set.
        """
        ret = self._vtk_obj.Initialize()
        return ret
        

    def is_grid_local(self, *args):
        """
        V.is_grid_local(int) -> bool
        C++: bool IsGridLocal(const int gridID)
        Returns true iff the grid corresponding to the given grid_id is
        local.
        """
        ret = self._wrap_call(self._vtk_obj.IsGridLocal, *args)
        return ret

    def is_grid_remote(self, *args):
        """
        V.is_grid_remote(int) -> bool
        C++: bool IsGridRemote(const int gridID)
        Returns true iff the grid is remote, otherwise false.
        """
        ret = self._wrap_call(self._vtk_obj.IsGridRemote, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_grids', 'GetNumberOfGrids'),
    ('whole_extent', 'GetWholeExtent'), ('number_of_ghost_layers',
    'GetNumberOfGhostLayers'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'number_of_ghost_layers',
    'number_of_grids', 'whole_extent'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(PStructuredGridConnectivity, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit PStructuredGridConnectivity properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['number_of_ghost_layers', 'number_of_grids',
            'whole_extent']),
            title='Edit PStructuredGridConnectivity properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit PStructuredGridConnectivity properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

