# -*- coding: binary -*-
require 'rex/post/meterpreter/extensions/stdapi/railgun/const_manager'

module Rex
module Post
module Meterpreter
module Extensions
module Stdapi
module Railgun
module Def

#
# A container holding useful Linux API Constants.
#
class DefApiConstants_linux < ApiConstants

  #
  # Slurp in a giant list of known constants.
  #
  def self.add_constants(const_mgr)
    const_mgr.add_const('MAP_FILE',       0x00)
    const_mgr.add_const('MAP_SHARED',     0x01)
    const_mgr.add_const('MAP_PRIVATE',    0x02)
    const_mgr.add_const('MAP_FIXED',      0x10)
    const_mgr.add_const('MAP_ANON',       0x20)
    const_mgr.add_const('MAP_ANONYMOUS',  0x20)
    const_mgr.add_const('PROT_NONE',      0x00)
    const_mgr.add_const('PROT_READ',      0x01)
    const_mgr.add_const('PROT_WRITE',     0x02)
    const_mgr.add_const('PROT_EXEC',      0x04)
    const_mgr.add_const('PROT_GROWSDOWN', 0x01000000)
    const_mgr.add_const('PROT_GROWSUP',   0x02000000)

    const_mgr.add_const('PF_UNSPEC',         0x00000000)
    const_mgr.add_const('PF_LOCAL',          0x00000001)
    const_mgr.add_const('PF_UNIX',           0x00000000)
    const_mgr.add_const('PF_FILE',           0x00000000)
    const_mgr.add_const('PF_INET',           0x00000002)
    const_mgr.add_const('PF_AX25',           0x00000003)
    const_mgr.add_const('PF_IPX',            0x00000004)
    const_mgr.add_const('PF_APPLETALK',      0x00000005)
    const_mgr.add_const('PF_NETROM',         0x00000006)
    const_mgr.add_const('PF_BRIDGE',         0x00000007)
    const_mgr.add_const('PF_ATMPVC',         0x00000008)
    const_mgr.add_const('PF_X25',            0x00000009)
    const_mgr.add_const('PF_INET6',          0x0000000a)
    const_mgr.add_const('PF_ROSE',           0x0000000b)
    const_mgr.add_const('PF_DECnet',         0x0000000c)
    const_mgr.add_const('PF_NETBEUI',        0x0000000d)
    const_mgr.add_const('PF_SECURITY',       0x0000000e)
    const_mgr.add_const('PF_KEY',            0x0000000f)
    const_mgr.add_const('PF_NETLINK',        0x00000010)
    const_mgr.add_const('PF_ROUTE',          0x00000000)
    const_mgr.add_const('PF_PACKET',         0x00000011)
    const_mgr.add_const('PF_ASH',            0x00000012)
    const_mgr.add_const('PF_ECONET',         0x00000013)
    const_mgr.add_const('PF_ATMSVC',         0x00000014)
    const_mgr.add_const('PF_RDS',            0x00000015)
    const_mgr.add_const('PF_SNA',            0x00000016)
    const_mgr.add_const('PF_IRDA',           0x00000017)
    const_mgr.add_const('PF_PPPOX',          0x00000018)
    const_mgr.add_const('PF_WANPIPE',        0x00000019)
    const_mgr.add_const('PF_LLC',            0x0000001a)
    const_mgr.add_const('PF_IB',             0x0000001b)
    const_mgr.add_const('PF_MPLS',           0x0000001c)
    const_mgr.add_const('PF_CAN',            0x0000001d)
    const_mgr.add_const('PF_TIPC',           0x0000001e)
    const_mgr.add_const('PF_BLUETOOTH',      0x0000001f)
    const_mgr.add_const('PF_IUCV',           0x00000020)
    const_mgr.add_const('PF_RXRPC',          0x00000021)
    const_mgr.add_const('PF_ISDN',           0x00000022)
    const_mgr.add_const('PF_PHONET',         0x00000023)
    const_mgr.add_const('PF_IEEE802154',     0x00000024)
    const_mgr.add_const('PF_CAIF',           0x00000025)
    const_mgr.add_const('PF_ALG',            0x00000026)
    const_mgr.add_const('PF_NFC',            0x00000027)
    const_mgr.add_const('PF_VSOCK',          0x00000028)
    const_mgr.add_const('PF_KCM',            0x00000029)
    const_mgr.add_const('PF_MAX',            0x0000002a)

    const_mgr.add_const('AF_UNSPEC',         0x00000000)
    const_mgr.add_const('AF_LOCAL',          0x00000001)
    const_mgr.add_const('AF_UNIX',           0x00000000)
    const_mgr.add_const('AF_FILE',           0x00000000)
    const_mgr.add_const('AF_INET',           0x00000002)
    const_mgr.add_const('AF_AX25',           0x00000003)
    const_mgr.add_const('AF_IPX',            0x00000004)
    const_mgr.add_const('AF_APPLETALK',      0x00000005)
    const_mgr.add_const('AF_NETROM',         0x00000006)
    const_mgr.add_const('AF_BRIDGE',         0x00000007)
    const_mgr.add_const('AF_ATMPVC',         0x00000008)
    const_mgr.add_const('AF_X25',            0x00000009)
    const_mgr.add_const('AF_INET6',          0x0000000a)
    const_mgr.add_const('AF_ROSE',           0x0000000b)
    const_mgr.add_const('AF_DECnet',         0x0000000c)
    const_mgr.add_const('AF_NETBEUI',        0x0000000d)
    const_mgr.add_const('AF_SECURITY',       0x0000000e)
    const_mgr.add_const('AF_KEY',            0x0000000f)
    const_mgr.add_const('AF_NETLINK',        0x00000010)
    const_mgr.add_const('AF_ROUTE',          0x00000000)
    const_mgr.add_const('AF_PACKET',         0x00000011)
    const_mgr.add_const('AF_ASH',            0x00000012)
    const_mgr.add_const('AF_ECONET',         0x00000013)
    const_mgr.add_const('AF_ATMSVC',         0x00000014)
    const_mgr.add_const('AF_RDS',            0x00000015)
    const_mgr.add_const('AF_SNA',            0x00000016)
    const_mgr.add_const('AF_IRDA',           0x00000017)
    const_mgr.add_const('AF_PPPOX',          0x00000018)
    const_mgr.add_const('AF_WANPIPE',        0x00000019)
    const_mgr.add_const('AF_LLC',            0x0000001a)
    const_mgr.add_const('AF_IB',             0x0000001b)
    const_mgr.add_const('AF_MPLS',           0x0000001c)
    const_mgr.add_const('AF_CAN',            0x0000001d)
    const_mgr.add_const('AF_TIPC',           0x0000001e)
    const_mgr.add_const('AF_BLUETOOTH',      0x0000001f)
    const_mgr.add_const('AF_IUCV',           0x00000020)
    const_mgr.add_const('AF_RXRPC',          0x00000021)
    const_mgr.add_const('AF_ISDN',           0x00000022)
    const_mgr.add_const('AF_PHONET',         0x00000023)
    const_mgr.add_const('AF_IEEE802154',     0x00000024)
    const_mgr.add_const('AF_CAIF',           0x00000025)
    const_mgr.add_const('AF_ALG',            0x00000026)
    const_mgr.add_const('AF_NFC',            0x00000027)
    const_mgr.add_const('AF_VSOCK',          0x00000028)
    const_mgr.add_const('AF_KCM',            0x00000029)
    const_mgr.add_const('AF_MAX',            0x0000002a)

    const_mgr.add_const('SOL_RAW',           0x000000ff)
    const_mgr.add_const('SOL_DECNET',        0x00000105)
    const_mgr.add_const('SOL_X25',           0x00000106)
    const_mgr.add_const('SOL_PACKET',        0x00000107)
    const_mgr.add_const('SOL_ATM',           0x00000108)
    const_mgr.add_const('SOL_AAL',           0x00000109)
    const_mgr.add_const('SOL_IRDA',          0x0000010a)
    const_mgr.add_const('SOL_NETBEUI',       0x0000010b)
    const_mgr.add_const('SOL_LLC',           0x0000010c)
    const_mgr.add_const('SOL_DCCP',          0x0000010d)
    const_mgr.add_const('SOL_NETLINK',       0x0000010e)
    const_mgr.add_const('SOL_TIPC',          0x0000010f)
    const_mgr.add_const('SOL_RXRPC',         0x00000110)
    const_mgr.add_const('SOL_PPPOL2TP',      0x00000111)
    const_mgr.add_const('SOL_BLUETOOTH',     0x00000112)
    const_mgr.add_const('SOL_PNPIPE',        0x00000113)
    const_mgr.add_const('SOL_RDS',           0x00000114)
    const_mgr.add_const('SOL_IUCV',          0x00000115)
    const_mgr.add_const('SOL_CAIF',          0x00000116)
    const_mgr.add_const('SOL_ALG',           0x00000117)
    const_mgr.add_const('SOL_NFC',           0x00000118)
    const_mgr.add_const('SOL_KCM',           0x00000119)
  end
end

end; end; end; end; end; end; end
